/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization;

import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptoFactory;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.internal.LearnerThread;
import com.swirlds.common.merkle.synchronization.internal.Lesson;
import com.swirlds.common.merkle.synchronization.internal.QueryResponse;
import com.swirlds.common.merkle.synchronization.internal.ReconnectNodeCount;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.CustomReconnectRoot;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.common.merkle.synchronization.views.StandardLearnerTreeView;
import com.swirlds.common.merkle.utility.MerkleTreeVisualizer;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.SynchronizationCompletePayload;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LearningSynchronizer
implements ReconnectNodeCount {
    private static final String WORK_GROUP_NAME = "learning-synchronizer";
    private static final Logger logger = LogManager.getLogger(LearningSynchronizer.class);
    private final MerkleDataInputStream inputStream;
    private final MerkleDataOutputStream outputStream;
    private final Queue<MerkleNode> rootsToReceive;
    private final Deque<LearnerTreeView<?>> viewsToInitialize;
    private final Runnable breakConnection;
    private MerkleNode newRoot;
    private int leafNodesReceived;
    private int internalNodesReceived;
    private int redundantLeafNodes;
    private int redundantInternalNodes;
    private long synchronizationTimeMilliseconds;
    private long hashTimeMilliseconds;
    private long initializationTimeMilliseconds;
    protected final ReconnectConfig reconnectConfig;
    private final ThreadManager threadManager;

    public LearningSynchronizer(@NonNull ThreadManager threadManager, @NonNull MerkleDataInputStream in, @NonNull MerkleDataOutputStream out, @NonNull MerkleNode root, @NonNull Runnable breakConnection, @NonNull ReconnectConfig reconnectConfig) {
        this.threadManager = Objects.requireNonNull(threadManager, "threadManager is null");
        this.inputStream = Objects.requireNonNull(in, "inputStream is null");
        this.outputStream = Objects.requireNonNull(out, "outputStream is null");
        this.reconnectConfig = Objects.requireNonNull(reconnectConfig, "reconnectConfig is null");
        this.rootsToReceive = new LinkedList<MerkleNode>();
        this.viewsToInitialize = new LinkedList();
        this.rootsToReceive.add(root);
        this.breakConnection = breakConnection;
    }

    public void synchronize() throws InterruptedException {
        try {
            this.receiveTree();
            this.initialize();
            this.hash();
            this.logStatistics();
        }
        catch (InterruptedException ex) {
            logger.warn(LogMarker.RECONNECT.getMarker(), "synchronization interrupted");
            Thread.currentThread().interrupt();
            this.abort();
            throw ex;
        }
        catch (Exception ex) {
            this.abort();
            throw new MerkleSynchronizationException(ex);
        }
    }

    private void abort() {
        logger.warn(LogMarker.RECONNECT.getMarker(), "Deleting partially constructed tree:\n{}", (Object)new MerkleTreeVisualizer(this.newRoot).setDepth(5).setUseHashes(false).setUseMnemonics(false).render());
        try {
            if (this.newRoot != null) {
                this.newRoot.release();
            }
        }
        catch (Exception ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "exception thrown while releasing tree", (Throwable)ex);
        }
    }

    private void receiveTree() throws InterruptedException {
        logger.info(LogMarker.RECONNECT.getMarker(), "synchronizing tree");
        long start = System.currentTimeMillis();
        while (!this.rootsToReceive.isEmpty()) {
            MerkleNode root = this.receiveTree(this.rootsToReceive.remove());
            if (this.newRoot != null) continue;
            this.newRoot = root;
        }
        this.synchronizationTimeMilliseconds = System.currentTimeMillis() - start;
        logger.info(LogMarker.RECONNECT.getMarker(), "synchronization complete");
    }

    private void initialize() {
        logger.info(LogMarker.RECONNECT.getMarker(), "initializing tree");
        long start = System.currentTimeMillis();
        while (!this.viewsToInitialize.isEmpty()) {
            this.viewsToInitialize.removeFirst().initialize();
        }
        this.initializationTimeMilliseconds = System.currentTimeMillis() - start;
        logger.info(LogMarker.RECONNECT.getMarker(), "initialization complete");
    }

    private void hash() throws InterruptedException {
        logger.info(LogMarker.RECONNECT.getMarker(), "hashing tree");
        long start = System.currentTimeMillis();
        try {
            MerkleCryptoFactory.getInstance().digestTreeAsync(this.newRoot).get();
        }
        catch (ExecutionException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "exception while computing hash of reconstructed tree", (Throwable)e);
            return;
        }
        this.hashTimeMilliseconds = System.currentTimeMillis() - start;
        logger.info(LogMarker.RECONNECT.getMarker(), "hashing complete");
    }

    private void logStatistics() {
        logger.info(LogMarker.RECONNECT.getMarker(), () -> new SynchronizationCompletePayload("Finished synchronization").setTimeInSeconds((double)this.synchronizationTimeMilliseconds * 0.001).setHashTimeInSeconds((double)this.hashTimeMilliseconds * 0.001).setInitializationTimeInSeconds((double)this.initializationTimeMilliseconds * 0.001).setTotalNodes(this.leafNodesReceived + this.internalNodesReceived).setLeafNodes(this.leafNodesReceived).setRedundantLeafNodes(this.redundantLeafNodes).setInternalNodes(this.internalNodesReceived).setRedundantInternalNodes(this.redundantInternalNodes).toString());
    }

    public MerkleNode getRoot() {
        return this.newRoot;
    }

    private <T> MerkleNode receiveTree(MerkleNode root) throws InterruptedException {
        LearnerTreeView<MerkleNode> view;
        logger.info(LogMarker.RECONNECT.getMarker(), "receiving tree rooted at {} with route {}", (Object)(root == null ? "(unknown)" : root.getClass().getName()), root == null ? "[]" : root.getRoute());
        StandardWorkGroup workGroup = new StandardWorkGroup(this.threadManager, WORK_GROUP_NAME, this.breakConnection);
        if (root == null || !root.hasCustomReconnectView()) {
            view = new StandardLearnerTreeView(root);
        } else {
            assert (root instanceof CustomReconnectRoot);
            view = ((CustomReconnectRoot)root).buildLearnerView();
        }
        AsyncInputStream in = new AsyncInputStream(this.inputStream, workGroup, () -> new Lesson(view), this.reconnectConfig);
        AsyncOutputStream<QueryResponse> out = this.buildOutputStream(workGroup, this.outputStream);
        in.start();
        out.start();
        AtomicReference reconstructedRoot = new AtomicReference();
        new LearnerThread<MerkleNode>(workGroup, this.threadManager, in, out, this.rootsToReceive, reconstructedRoot, view, this).start();
        InterruptedException interruptException = null;
        try {
            workGroup.waitForTermination();
        }
        catch (InterruptedException e) {
            interruptException = e;
            logger.warn(LogMarker.RECONNECT.getMarker(), "interrupted while waiting for work group termination");
        }
        if (interruptException != null || workGroup.hasExceptions()) {
            in.abort();
            MerkleNode merkleRoot = view.getMerkleRoot((MerkleNode)reconstructedRoot.get());
            if (merkleRoot != null && merkleRoot.getReservationCount() == 0) {
                logger.warn(LogMarker.RECONNECT.getMarker(), "deleting partially constructed subtree");
                merkleRoot.release();
            }
            if (interruptException != null) {
                throw interruptException;
            }
            throw new MerkleSynchronizationException("Synchronization failed with exceptions");
        }
        this.viewsToInitialize.addFirst(view);
        return view.getMerkleRoot((MerkleNode)reconstructedRoot.get());
    }

    protected AsyncOutputStream<QueryResponse> buildOutputStream(StandardWorkGroup workGroup, SerializableDataOutputStream out) {
        return new AsyncOutputStream<QueryResponse>(out, workGroup, this.reconnectConfig);
    }

    @Override
    public void incrementLeafCount() {
        ++this.leafNodesReceived;
    }

    @Override
    public void incrementRedundantLeafCount() {
        ++this.redundantLeafNodes;
    }

    @Override
    public void incrementInternalCount() {
        ++this.internalNodesReceived;
    }

    @Override
    public void incrementRedundantInternalCount() {
        ++this.redundantInternalNodes;
    }
}

