/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.internal;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.config.singleton.ConfigurationHolder;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

public class NodeToSend {
    private final MerkleNode node;
    private volatile boolean responseReceived;
    private volatile boolean responseStatus;
    private final long unconditionalSendTimeMilliseconds;
    private final List<NodeToSend> children;

    public NodeToSend(MerkleNode node) {
        this.node = node;
        this.responseReceived = false;
        this.responseStatus = false;
        this.children = node != null && !node.isLeaf() ? new LinkedList<NodeToSend>() : null;
        ReconnectConfig reconnectConfig = ConfigurationHolder.getConfigData(ReconnectConfig.class);
        this.unconditionalSendTimeMilliseconds = System.currentTimeMillis() + reconnectConfig.maxAckDelay().toMillis();
    }

    public synchronized void registerChild(NodeToSend child) {
        if (this.children == null) {
            throw new IllegalStateException("can not add children to leaf node");
        }
        this.children.add(child);
        child.responseStatus = this.responseStatus;
    }

    private synchronized void addChildrenToQueue(Queue<NodeToSend> queue) {
        queue.addAll(this.children);
    }

    public MerkleNode getNode() {
        return this.node;
    }

    public void registerResponse(boolean learnerHasNode) {
        if (learnerHasNode) {
            this.cancelTransmission();
        }
        this.responseReceived = true;
    }

    public boolean getResponseStatus() {
        return this.responseStatus;
    }

    public void waitForResponse() {
        if (this.responseReceived || this.responseStatus) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.unconditionalSendTimeMilliseconds) {
            return;
        }
        long sleepTime = this.unconditionalSendTimeMilliseconds - currentTime;
        try {
            TimeUnit.MILLISECONDS.sleep(sleepTime);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private void cancelTransmission() {
        LinkedList<NodeToSend> queue = new LinkedList<NodeToSend>();
        queue.add(this);
        while (!queue.isEmpty()) {
            NodeToSend next = (NodeToSend)queue.remove();
            if (next.responseStatus) continue;
            next.responseStatus = true;
            if (this.node == null || next.node == null || next.node.isLeaf()) continue;
            next.addChildrenToQueue(queue);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("response", this.responseReceived ? Boolean.valueOf(this.responseStatus) : "?").append("node", (Object)this.node).toString();
    }
}

