/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.MetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.Objects;

public interface Counter
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.COUNTER;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.INT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    default public Long get(Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public long get();

    public void add(long var1);

    public void increment();

    public static final class Config
    extends MetricConfig<Counter, Config> {
        public Config(@NonNull String category, @NonNull String name) {
            super(category, name, "%d");
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit) {
            super(category, name, description, unit, "%d");
        }

        @Override
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit());
        }

        @Override
        public Config withUnit(@NonNull String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit);
        }

        @Override
        public Class<Counter> getResultClass() {
            return Counter.class;
        }

        @Override
        @NonNull
        public Counter create(@NonNull MetricsFactory factory) {
            return factory.createCounter(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).toString();
        }
    }
}

