/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.MetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;

public interface DoubleAccumulator
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.ACCUMULATOR;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.FLOAT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    default public Double get(@NonNull Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public double get();

    public double getInitialValue();

    public void update(double var1);

    public static final class Config
    extends MetricConfig<DoubleAccumulator, Config> {
        private final DoubleBinaryOperator accumulator;
        private final DoubleSupplier initializer;
        private final double initialValue;

        public Config(@NonNull String category, @NonNull String name) {
            super(category, name, "%,11.3f");
            this.accumulator = Double::max;
            this.initializer = null;
            this.initialValue = 0.0;
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format, @NonNull DoubleBinaryOperator accumulator, @Nullable DoubleSupplier initializer, double initialValue) {
            super(category, name, description, unit, format);
            this.accumulator = Objects.requireNonNull(accumulator, "accumulator");
            this.initializer = initializer;
            this.initialValue = initialValue;
        }

        @Override
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getAccumulator(), this.getInitializer(), this.getInitialValue());
        }

        @Override
        public Config withUnit(@NonNull String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getAccumulator(), this.getInitializer(), this.getInitialValue());
        }

        public Config withFormat(@NonNull String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getAccumulator(), this.getInitializer(), this.getInitialValue());
        }

        @NonNull
        public DoubleBinaryOperator getAccumulator() {
            return this.accumulator;
        }

        @Nullable
        public DoubleSupplier getInitializer() {
            return this.initializer;
        }

        @NonNull
        public Config withAccumulator(@NonNull DoubleBinaryOperator accumulator) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), accumulator, this.getInitializer(), this.getInitialValue());
        }

        public double getInitialValue() {
            return this.initialValue;
        }

        @NonNull
        public Config withInitialValue(double initialValue) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getAccumulator(), this.getInitializer(), initialValue);
        }

        @NonNull
        public Config withInitializer(@NonNull DoubleSupplier initializer) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), this.getAccumulator(), Objects.requireNonNull(initializer, "initializer"), this.getInitialValue());
        }

        @Override
        public Class<DoubleAccumulator> getResultClass() {
            return DoubleAccumulator.class;
        }

        @Override
        @NonNull
        public DoubleAccumulator create(@NonNull MetricsFactory factory) {
            return factory.createDoubleAccumulator(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("initialValue", (Object)this.initialValue).toString();
        }
    }
}

