/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.MetricType;
import com.swirlds.common.metrics.MetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.Objects;

public interface IntegerGauge
extends Metric {
    @Override
    default public MetricType getMetricType() {
        return MetricType.GAUGE;
    }

    @Override
    default public Metric.DataType getDataType() {
        return Metric.DataType.INT;
    }

    @Override
    default public EnumSet<Metric.ValueType> getValueTypes() {
        return EnumSet.of(Metric.ValueType.VALUE);
    }

    @Override
    default public Integer get(@NonNull Metric.ValueType valueType) {
        Objects.requireNonNull(valueType, "valueType");
        if (valueType == Metric.ValueType.VALUE) {
            return this.get();
        }
        throw new IllegalArgumentException("Unsupported ValueType: " + valueType);
    }

    public int get();

    public void set(int var1);

    public static final class Config
    extends MetricConfig<IntegerGauge, Config> {
        private final int initialValue;

        public Config(@NonNull String category, @NonNull String name) {
            super(category, name, "%d");
            this.initialValue = 0;
        }

        private Config(@NonNull String category, @NonNull String name, @NonNull String description, @NonNull String unit, @NonNull String format, int initialValue) {
            super(category, name, description, unit, format);
            this.initialValue = initialValue;
        }

        @Override
        public Config withDescription(@NonNull String description) {
            return new Config(this.getCategory(), this.getName(), description, this.getUnit(), this.getFormat(), this.getInitialValue());
        }

        @Override
        public Config withUnit(@NonNull String unit) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), unit, this.getFormat(), this.getInitialValue());
        }

        @NonNull
        public Config withFormat(@NonNull String format) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), format, this.getInitialValue());
        }

        public int getInitialValue() {
            return this.initialValue;
        }

        @NonNull
        public Config withInitialValue(int initialValue) {
            return new Config(this.getCategory(), this.getName(), this.getDescription(), this.getUnit(), this.getFormat(), initialValue);
        }

        @Override
        public Class<IntegerGauge> getResultClass() {
            return IntegerGauge.class;
        }

        @Override
        @NonNull
        public IntegerGauge create(@NonNull MetricsFactory factory) {
            return factory.createIntegerGauge(this);
        }

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("initialValue", (Object)this.initialValue).toString();
        }
    }
}

