/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricsFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public abstract class MetricConfig<T extends Metric, C extends MetricConfig<T, C>> {
    private static final int MAX_DESCRIPTION_LENGTH = 255;
    private final String category;
    private final String name;
    private final String description;
    private final String unit;
    private final String format;

    protected MetricConfig(String category, String name, String description, String unit, String format) {
        this.category = ArgumentUtils.throwArgBlank((String)category, (String)"category");
        this.name = ArgumentUtils.throwArgBlank((String)name, (String)"name");
        this.description = ArgumentUtils.throwArgBlank((String)description, (String)"description");
        if (description.length() > 255) {
            throw new IllegalArgumentException("Description has " + description.length() + " characters, must not be longer than 255 characters: " + description);
        }
        this.unit = Objects.requireNonNull(unit, "unit");
        this.format = ArgumentUtils.throwArgBlank((String)format, (String)"format");
    }

    protected MetricConfig(String category, String name, String defaultFormat) {
        this(category, name, name, "", defaultFormat);
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract C withDescription(String var1);

    public String getUnit() {
        return this.unit;
    }

    public abstract C withUnit(String var1);

    public String getFormat() {
        return this.format;
    }

    public abstract Class<T> getResultClass();

    @NonNull
    public abstract T create(MetricsFactory var1);

    public String toString() {
        return new ToStringBuilder((Object)this).append("category", (Object)this.category).append("name", (Object)this.name).append("description", (Object)this.description).append("unit", (Object)this.unit).append("format", (Object)this.format).append("resultClass", this.getResultClass()).toString();
    }

    public static Metric.DataType mapDataType(Class<?> type) {
        if (Double.class.equals(type) || Float.class.equals(type)) {
            return Metric.DataType.FLOAT;
        }
        if (Number.class.isAssignableFrom(type)) {
            return Metric.DataType.INT;
        }
        if (Boolean.class.equals(type)) {
            return Metric.DataType.BOOLEAN;
        }
        return Metric.DataType.STRING;
    }
}

