/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.extensions;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.metrics.extensions.PhaseTimer;
import com.swirlds.common.units.TimeUnit;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class PhaseTimerBuilder<T extends Enum<T>> {
    private final PlatformContext platformContext;
    private final Time time;
    private final Class<T> clazz;
    private final Set<T> phases;
    private final String metricsCategory;
    private String metricsNamePrefix;
    private T initialPhase;
    private boolean fractionMetricsEnabled = false;
    private boolean absoluteTimeMetricsEnabled = false;
    private TimeUnit absoluteUnit = TimeUnit.UNIT_MICROSECONDS;

    public PhaseTimerBuilder(@NonNull PlatformContext platformContext, @NonNull Time time, @NonNull String metricsCategory, @NonNull Class<T> clazz) {
        this.clazz = Objects.requireNonNull(clazz);
        this.platformContext = Objects.requireNonNull(platformContext);
        this.time = Objects.requireNonNull(time);
        this.metricsCategory = Objects.requireNonNull(metricsCategory);
        this.phases = EnumSet.allOf(Objects.requireNonNull(clazz));
        if (this.phases.isEmpty()) {
            throw new IllegalArgumentException("The enum class " + clazz.getName() + " has zero values.");
        }
        this.initialPhase = (Enum)this.phases.iterator().next();
    }

    @NonNull
    public PhaseTimer<T> build() {
        return new PhaseTimer(this);
    }

    @NonNull
    public PhaseTimerBuilder<T> setMetricsNamePrefix(@NonNull String metricsNamePrefix) {
        this.metricsNamePrefix = Objects.requireNonNull(metricsNamePrefix);
        return this;
    }

    @NonNull
    public PhaseTimerBuilder<T> setInitialPhase(@NonNull T initialPhase) {
        this.initialPhase = (Enum)Objects.requireNonNull(initialPhase);
        return this;
    }

    @NonNull
    public PhaseTimerBuilder<T> enableFractionalMetrics() {
        this.fractionMetricsEnabled = true;
        return this;
    }

    @NonNull
    public PhaseTimerBuilder<T> enableAbsoluteTimeMetrics() {
        this.absoluteTimeMetricsEnabled = true;
        return this;
    }

    @NonNull
    public PhaseTimerBuilder<T> setAbsoluteUnit(@NonNull TimeUnit absoluteUnit) {
        this.absoluteUnit = Objects.requireNonNull(absoluteUnit);
        return this;
    }

    @NonNull
    PlatformContext getPlatformContext() {
        return this.platformContext;
    }

    @NonNull
    Time getTime() {
        return this.time;
    }

    @NonNull
    Set<T> getPhases() {
        return this.phases;
    }

    @NonNull
    String getMetricsCategory() {
        return this.metricsCategory;
    }

    @NonNull
    String getMetricsNamePrefix() {
        if (this.metricsNamePrefix == null) {
            return this.clazz.getSimpleName();
        }
        return this.metricsNamePrefix;
    }

    @NonNull
    T getInitialPhase() {
        return this.initialPhase;
    }

    boolean areFractionMetricsEnabled() {
        return this.fractionMetricsEnabled;
    }

    boolean areAbsoluteTimeMetricsEnabled() {
        return this.absoluteTimeMetricsEnabled;
    }

    @NonNull
    TimeUnit getAbsoluteUnit() {
        return this.absoluteUnit;
    }
}

