/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.DoubleAccumulator;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import com.swirlds.common.threading.atomic.AtomicDouble;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleSupplier;

public class DefaultDoubleAccumulator
extends DefaultMetric
implements DoubleAccumulator {
    private final AtomicDouble container;
    private final DoubleBinaryOperator accumulator;
    private final DoubleSupplier initializer;

    public DefaultDoubleAccumulator(@NonNull DoubleAccumulator.Config config) {
        super(config);
        double initialValue = config.getInitialValue();
        DoubleSupplier configInitializer = config.getInitializer();
        this.accumulator = config.getAccumulator();
        this.initializer = configInitializer != null ? configInitializer : () -> initialValue;
        this.container = new AtomicDouble(this.initializer.getAsDouble());
    }

    @Override
    public double getInitialValue() {
        return this.initializer.getAsDouble();
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.container.getAndSet(this.initializer.getAsDouble())));
    }

    @Override
    public double get() {
        return this.container.get();
    }

    @Override
    public void update(double other) {
        this.container.accumulateAndGet(other, this.accumulator);
    }

    @Override
    public void reset() {
        this.container.set(this.initializer.getAsDouble());
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.get()).toString();
    }
}

