/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.IntegerGauge;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.platform.DefaultMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultIntegerGauge
extends DefaultMetric
implements IntegerGauge {
    private final AtomicInteger value;

    public DefaultIntegerGauge(IntegerGauge.Config config) {
        super(config);
        this.value = new AtomicInteger(config.getInitialValue());
    }

    @Override
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, this.get()));
    }

    @Override
    public int get() {
        return this.value.get();
    }

    @Override
    public void set(int newValue) {
        this.value.set(newValue);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", (Object)this.value.get()).toString();
    }
}

