/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.PlatformMetric;
import com.swirlds.common.metrics.platform.Snapshot;
import com.swirlds.common.metrics.statistics.StatsBuffered;
import java.util.List;
import java.util.Objects;

public abstract class DefaultMetric
implements Metric,
PlatformMetric {
    private final String category;
    private final String name;
    private final String description;
    private final String unit;
    private final String format;

    DefaultMetric(MetricConfig<?, ?> config) {
        Objects.requireNonNull(config, "config must not be null");
        this.category = config.getCategory();
        this.name = config.getName();
        this.description = config.getDescription();
        this.unit = config.getUnit();
        this.format = config.getFormat();
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public abstract List<Snapshot.SnapshotEntry> takeSnapshot();

    @Override
    public void reset() {
    }

    @Override
    public StatsBuffered getStatsBuffered() {
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DefaultMetric metric = (DefaultMetric)other;
        return this.category.equals(metric.category) && this.name.equals(metric.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.category, this.name);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("category", (Object)this.category).append("name", (Object)this.name).append("description", (Object)this.description).append("unit", (Object)this.unit).append("format", (Object)this.format).append("dataType", (Object)this.getDataType()).toString();
    }
}

