/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.common.metrics.Metric;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.PlatformMetrics;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.common.metrics.config.MetricsConfig;
import com.swirlds.common.metrics.platform.MetricKeyRegistry;
import com.swirlds.common.metrics.platform.MetricsEvent;
import com.swirlds.common.metrics.platform.MetricsEventBus;
import com.swirlds.common.metrics.platform.MetricsUpdateService;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.utility.CommonUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class DefaultMetrics
implements PlatformMetrics {
    public static final int EXCEPTION_RATE_THRESHOLD = 10;
    private static final String CATEGORY = "category";
    private static final String NAME = "name";
    private final NodeId selfId;
    private final MetricKeyRegistry metricKeyRegistry;
    private final NavigableMap<String, Metric> metricMap = new ConcurrentSkipListMap<String, Metric>();
    private final Collection<Metric> metricsView = Collections.unmodifiableCollection(this.metricMap.values());
    private final Map<String, String> globalMetricKeys = new ConcurrentHashMap<String, String>();
    private final PlatformMetricsFactory factory;
    private final MetricsEventBus<MetricsEvent> eventBus;
    private final MetricsUpdateService updateService;

    public DefaultMetrics(NodeId selfId, MetricKeyRegistry metricKeyRegistry, ScheduledExecutorService executor, PlatformMetricsFactory factory, MetricsConfig metricsConfig) {
        this.selfId = selfId;
        this.metricKeyRegistry = CommonUtils.throwArgNull(metricKeyRegistry, "metricsKeyRegistry");
        this.factory = CommonUtils.throwArgNull(factory, "factory");
        CommonUtils.throwArgNull(executor, "executor");
        this.eventBus = new MetricsEventBus(executor);
        CommonUtils.throwArgNull(metricsConfig, "metricsConfig");
        this.updateService = metricsConfig.metricsUpdatePeriodMillis() <= 0L ? null : new MetricsUpdateService(executor, metricsConfig.metricsUpdatePeriodMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public NodeId getNodeId() {
        return this.selfId;
    }

    @Override
    public Metric getMetric(String category, String name) {
        CommonUtils.throwArgNull(category, CATEGORY);
        CommonUtils.throwArgNull(name, NAME);
        return (Metric)this.metricMap.get(DefaultMetrics.calculateMetricKey(category, name));
    }

    @Override
    public Collection<Metric> findMetricsByCategory(String category) {
        CommonUtils.throwArgNull(category, CATEGORY);
        String start = category + ".";
        String end = category + "/";
        return Collections.unmodifiableCollection(this.metricMap.subMap(start, end).values());
    }

    @Override
    public Collection<Metric> getAll() {
        return this.metricsView;
    }

    public Runnable subscribe(Consumer<? super MetricsEvent> subscriber) {
        Supplier previousEventsSupplier = () -> this.metricMap.values().stream().map(metric -> new MetricsEvent(MetricsEvent.Type.ADDED, this.selfId, (Metric)metric));
        return this.eventBus.subscribe(subscriber, previousEventsSupplier);
    }

    @Override
    public <T extends Metric> T getOrCreate(MetricConfig<T, ?> config) {
        Class<T> clazz;
        CommonUtils.throwArgNull(config, "config");
        String key = DefaultMetrics.calculateMetricKey(config);
        Metric metric = (Metric)this.metricMap.get(key);
        if (metric == null) {
            if (!this.metricKeyRegistry.register(this.selfId, key, config.getResultClass())) {
                throw new IllegalStateException(String.format("A different metric with the category '%s' and name '%s' was already registered", config.getCategory(), config.getName()));
            }
            T newMetric = this.factory.createMetric(config);
            metric = (Metric)this.metricMap.putIfAbsent(key, (Metric)newMetric);
            if (metric == null) {
                MetricsEvent event = new MetricsEvent(MetricsEvent.Type.ADDED, this.selfId, (Metric)newMetric);
                this.eventBus.submit(event);
                return newMetric;
            }
        }
        if ((clazz = config.getResultClass()).isInstance(metric)) {
            return (T)((Metric)clazz.cast(metric));
        }
        throw new IllegalStateException("A metric with this category and name exists, but it has a different type: " + metric);
    }

    @Override
    public void remove(String category, String name) {
        CommonUtils.throwArgNull(category, CATEGORY);
        CommonUtils.throwArgNull(name, NAME);
        String metricKey = DefaultMetrics.calculateMetricKey(category, name);
        this.throwIfGlobal(metricKey);
        Metric metric = (Metric)this.metricMap.remove(metricKey);
        if (metric != null) {
            this.metricKeyRegistry.unregister(this.selfId, metricKey);
            MetricsEvent event = new MetricsEvent(MetricsEvent.Type.REMOVED, this.selfId, metric);
            this.eventBus.submit(event);
        }
    }

    @Override
    public void remove(Metric metric) {
        CommonUtils.throwArgNull(metric, "metric");
        String metricKey = DefaultMetrics.calculateMetricKey(metric);
        this.throwIfGlobal(metricKey);
        boolean removed = this.metricMap.remove(metricKey, metric);
        if (removed) {
            this.metricKeyRegistry.unregister(this.selfId, metricKey);
            MetricsEvent event = new MetricsEvent(MetricsEvent.Type.REMOVED, this.selfId, metric);
            this.eventBus.submit(event);
        }
    }

    @Override
    public void remove(MetricConfig<?, ?> config) {
        CommonUtils.throwArgNull(config, "config");
        String metricKey = DefaultMetrics.calculateMetricKey(config);
        this.throwIfGlobal(metricKey);
        this.metricMap.computeIfPresent(metricKey, (key, oldValue) -> {
            if (!config.getResultClass().isInstance(oldValue)) {
                return oldValue;
            }
            this.metricKeyRegistry.unregister(this.selfId, (String)key);
            MetricsEvent event = new MetricsEvent(MetricsEvent.Type.REMOVED, this.selfId, (Metric)oldValue);
            this.eventBus.submit(event);
            return null;
        });
    }

    private void throwIfGlobal(String metricKey) {
        if (this.globalMetricKeys.containsKey(metricKey)) {
            throw new IllegalArgumentException(String.format("Not possible to remove the global Metric (%s) from a non-global Metrics", metricKey));
        }
    }

    @Override
    public void addUpdater(Runnable updater) {
        CommonUtils.throwArgNull(updater, "updater");
        if (this.updateService != null) {
            this.updateService.addUpdater(updater);
        }
    }

    @Override
    public void removeUpdater(Runnable updater) {
        CommonUtils.throwArgNull(updater, "updater");
        if (this.updateService != null) {
            this.updateService.removeUpdater(updater);
        }
    }

    public void start() {
        if (this.updateService != null) {
            this.updateService.start();
        }
    }

    public boolean shutdown() throws InterruptedException {
        this.metricMap.entrySet().stream().filter(entry -> !this.globalMetricKeys.containsKey(entry.getKey())).map(entry -> new MetricsEvent(MetricsEvent.Type.REMOVED, this.selfId, (Metric)entry.getValue())).forEach(this.eventBus::submit);
        return this.updateService == null || this.updateService.shutdown();
    }

    public static String calculateMetricKey(String category, String name) {
        return category + "." + name;
    }

    public static String calculateMetricKey(Metric metric) {
        return DefaultMetrics.calculateMetricKey(metric.getCategory(), metric.getName());
    }

    public static String calculateMetricKey(MetricConfig<?, ?> config) {
        return DefaultMetrics.calculateMetricKey(config.getCategory(), config.getName());
    }

    public void handleGlobalMetrics(MetricsEvent event) {
        Metric metric = event.metric();
        String metricKey = DefaultMetrics.calculateMetricKey(metric);
        switch (event.type()) {
            case ADDED: {
                this.globalMetricKeys.put(metricKey, metricKey);
                this.metricMap.put(metricKey, metric);
                break;
            }
            case REMOVED: {
                this.metricMap.remove(metricKey);
                this.globalMetricKeys.remove(metricKey);
            }
        }
    }
}

