/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.sun.net.httpserver.HttpServer;
import com.swirlds.base.state.Lifecycle;
import com.swirlds.base.state.LifecyclePhase;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.metrics.PlatformMetricsFactory;
import com.swirlds.common.metrics.PlatformMetricsProvider;
import com.swirlds.common.metrics.config.MetricsConfig;
import com.swirlds.common.metrics.platform.DefaultMetrics;
import com.swirlds.common.metrics.platform.DefaultMetricsFactory;
import com.swirlds.common.metrics.platform.LegacyCsvWriter;
import com.swirlds.common.metrics.platform.MetricKeyRegistry;
import com.swirlds.common.metrics.platform.SnapshotService;
import com.swirlds.common.metrics.platform.prometheus.PrometheusConfig;
import com.swirlds.common.metrics.platform.prometheus.PrometheusEndpoint;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultMetricsProvider
implements PlatformMetricsProvider,
Lifecycle {
    private static final Logger logger = LogManager.getLogger(DefaultMetricsProvider.class);
    private final PlatformMetricsFactory factory;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(AdHocThreadManager.getStaticThreadManager().createThreadFactory("platform-core", "MetricsThread"));
    private final MetricKeyRegistry metricKeyRegistry = new MetricKeyRegistry();
    private final DefaultMetrics globalMetrics;
    private final ConcurrentMap<NodeId, DefaultMetrics> platformMetrics = new ConcurrentHashMap<NodeId, DefaultMetrics>();
    private final PrometheusEndpoint prometheusEndpoint;
    private final SnapshotService snapshotService;
    private final MetricsConfig metricsConfig;
    private final Configuration configuration;
    private LifecyclePhase lifecyclePhase = LifecyclePhase.NOT_STARTED;

    public DefaultMetricsProvider(@NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
        this.metricsConfig = (MetricsConfig)configuration.getConfigData(MetricsConfig.class);
        PrometheusConfig prometheusConfig = (PrometheusConfig)configuration.getConfigData(PrometheusConfig.class);
        this.factory = new DefaultMetricsFactory(this.metricsConfig);
        this.globalMetrics = new DefaultMetrics(null, this.metricKeyRegistry, this.executor, this.factory, this.metricsConfig);
        this.snapshotService = new SnapshotService(this.globalMetrics, this.executor, this.metricsConfig.getMetricsSnapshotDuration());
        PrometheusEndpoint endpoint = null;
        if (!this.metricsConfig.disableMetricsOutput() && prometheusConfig.endpointEnabled()) {
            InetSocketAddress address = new InetSocketAddress(prometheusConfig.endpointPortNumber());
            try {
                HttpServer httpServer = HttpServer.create(address, prometheusConfig.endpointMaxBacklogAllowed());
                endpoint = new PrometheusEndpoint(httpServer);
                this.globalMetrics.subscribe(endpoint::handleMetricsChange);
                this.snapshotService.subscribe(endpoint::handleSnapshots);
            }
            catch (IOException e) {
                logger.error("Exception while setting up Prometheus endpoint", (Throwable)e);
            }
        }
        this.prometheusEndpoint = endpoint;
    }

    @Override
    public Metrics createGlobalMetrics() {
        return this.globalMetrics;
    }

    @Override
    public Metrics createPlatformMetrics(@NonNull NodeId nodeId) {
        Objects.requireNonNull(nodeId, "selfId is null");
        DefaultMetrics newMetrics = new DefaultMetrics(nodeId, this.metricKeyRegistry, this.executor, this.factory, this.metricsConfig);
        DefaultMetrics oldMetrics = this.platformMetrics.putIfAbsent(nodeId, newMetrics);
        if (oldMetrics != null) {
            throw new IllegalStateException(String.format("PlatformMetrics for %s already exists", nodeId));
        }
        this.globalMetrics.subscribe(newMetrics::handleGlobalMetrics);
        if (this.lifecyclePhase == LifecyclePhase.STARTED) {
            newMetrics.start();
        }
        this.snapshotService.addPlatformMetric(newMetrics);
        if (!this.metricsConfig.disableMetricsOutput()) {
            String folderName = this.metricsConfig.csvOutputFolder();
            Path folderPath = Path.of(folderName.isBlank() ? FileUtils.getUserDir() : folderName, new String[0]);
            if (!this.metricsConfig.csvFileName().isBlank()) {
                LegacyCsvWriter legacyCsvWriter = new LegacyCsvWriter(nodeId, folderPath, this.configuration);
                this.snapshotService.subscribe(legacyCsvWriter::handleSnapshots);
            }
            if (this.prometheusEndpoint != null) {
                newMetrics.subscribe(this.prometheusEndpoint::handleMetricsChange);
            }
        }
        return newMetrics;
    }

    public LifecyclePhase getLifecyclePhase() {
        return this.lifecyclePhase;
    }

    public void start() {
        if (this.lifecyclePhase == LifecyclePhase.NOT_STARTED) {
            this.globalMetrics.start();
            for (DefaultMetrics metrics : this.platformMetrics.values()) {
                metrics.start();
            }
            this.snapshotService.start();
            this.lifecyclePhase = LifecyclePhase.STARTED;
        }
    }

    public void stop() {
        if (this.lifecyclePhase == LifecyclePhase.STARTED) {
            this.snapshotService.shutdown();
            this.prometheusEndpoint.close();
            this.lifecyclePhase = LifecyclePhase.STOPPED;
        }
    }
}

