/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.base.time.Time;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.metrics.SpeedometerMetric;
import com.swirlds.common.metrics.platform.AbstractDistributionMetric;
import com.swirlds.common.metrics.statistics.StatsBuffered;
import com.swirlds.common.metrics.statistics.StatsSpeedometer;

public class DefaultSpeedometerMetric
extends AbstractDistributionMetric
implements SpeedometerMetric {
    private final StatsSpeedometer speedometer;

    public DefaultSpeedometerMetric(SpeedometerMetric.Config config) {
        this(config, Time.getCurrent());
    }

    public DefaultSpeedometerMetric(SpeedometerMetric.Config config, Time time) {
        super(config, config.getHalfLife());
        this.speedometer = new StatsSpeedometer(this.halfLife, time);
    }

    @Override
    public StatsBuffered getStatsBuffered() {
        return this.speedometer;
    }

    @Override
    public void update(double value) {
        this.speedometer.update(value);
    }

    @Override
    public void cycle() {
        this.update(1.0);
    }

    @Override
    public double get() {
        return this.speedometer.getCyclesPerSecond();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("halfLife", (Object)this.halfLife).append("value", (Object)this.get()).toString();
    }
}

