/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.statistics;

import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.statistics.StatSettings;
import com.swirlds.common.metrics.statistics.StatSettingsFactory;
import com.swirlds.common.metrics.statistics.StatsBuffered;
import com.swirlds.common.metrics.statistics.StatsSpeedometer;
import com.swirlds.common.metrics.statistics.internal.StatsBuffer;
import com.swirlds.logging.legacy.LogMarker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated(forRemoval=true)
public class StatsRunningAverage
implements StatsBuffered {
    private static final Logger logger = LogManager.getLogger(StatsRunningAverage.class);
    private final Time time;
    private double mean = 0.0;
    private StatsSpeedometer values;
    private StatsSpeedometer times;
    private boolean firstRecord = true;
    private StatsBuffer allHistory;
    private StatsBuffer recentHistory;

    @Override
    public StatsBuffer getAllHistory() {
        return this.allHistory;
    }

    @Override
    public StatsBuffer getRecentHistory() {
        return this.recentHistory;
    }

    public StatsRunningAverage() {
        this(10.0);
    }

    public StatsRunningAverage(double halfLife) {
        this(halfLife, Time.getCurrent());
    }

    @Deprecated(forRemoval=true)
    public StatsRunningAverage(double halfLife, Time time) {
        this.time = time;
        this.reset(halfLife);
    }

    @Override
    public void reset(double halfLife) {
        StatSettings settings = StatSettingsFactory.get();
        this.firstRecord = true;
        this.values = new StatsSpeedometer(halfLife, false, this.time);
        this.times = new StatsSpeedometer(halfLife, false, this.time);
        this.allHistory = new StatsBuffer(settings.getBufferSize(), 0.0, settings.getSkipSeconds());
        this.recentHistory = new StatsBuffer(settings.getBufferSize(), settings.getRecentSeconds(), 0.0);
    }

    public void recordValue(double value) {
        if (Double.isNaN(value)) {
            return;
        }
        try {
            if (this.firstRecord || value == this.mean) {
                this.firstRecord = false;
                this.values.update(value);
                this.times.update(1.0);
                this.mean = value;
            } else {
                this.mean = this.values.update(value) / this.times.update(1.0);
            }
            this.allHistory.recordValue(this.mean);
            this.recentHistory.recordValue(this.mean);
        }
        catch (Exception e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception while updating statistics!", (Throwable)e);
        }
    }

    public double getWeightedMean() {
        return this.mean;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getMax() {
        if (this.allHistory.numBins() > 0) {
            return this.allHistory.yMaxMostRecent();
        }
        if (this.recentHistory.numBins() > 0) {
            return this.recentHistory.yMaxMostRecent();
        }
        return 0.0;
    }

    @Override
    public double getMin() {
        if (this.allHistory.numBins() > 0) {
            return this.allHistory.yMinMostRecent();
        }
        if (this.recentHistory.numBins() > 0) {
            return this.recentHistory.yMinMostRecent();
        }
        return 0.0;
    }

    @Override
    public double getStdDev() {
        if (this.allHistory.numBins() > 0) {
            return this.allHistory.yStdMostRecent();
        }
        if (this.recentHistory.numBins() > 0) {
            return this.recentHistory.yStdMostRecent();
        }
        return 0.0;
    }
}

