/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.startup;

import com.swirlds.common.system.NodeId;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.Set;

public record CommandLineArgs(@NonNull Set<NodeId> localNodesToStart) {
    public static final String OPTION_LOCAL = "-local";

    public static CommandLineArgs parse(@NonNull String[] args) {
        HashSet<NodeId> localNodesToStart = new HashSet<NodeId>();
        String currentOption = null;
        for (String item : args) {
            String arg = item.trim().toLowerCase();
            if (arg.equals(OPTION_LOCAL)) {
                currentOption = arg;
                continue;
            }
            if (currentOption == null) continue;
            try {
                localNodesToStart.add(new NodeId(Integer.parseInt(arg)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new CommandLineArgs(localNodesToStart);
    }
}

