/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.startup;

import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.util.DefaultShutdownCallbackRegistry;
import org.apache.logging.log4j.spi.LoggerContextFactory;

public final class Log4jSetup {
    public static final String LOG_CONTEXT_NAME = "swirlds-context";

    private Log4jSetup() {
    }

    private static void startLog4j(@NonNull Path configPath, @NonNull CountDownLatch log4jLoadedLatch) {
        try {
            LoggerContextFactory factory;
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            if (context.getName().equals(LOG_CONTEXT_NAME)) {
                log4jLoadedLatch.countDown();
                return;
            }
            context.setConfigLocation(configPath.toUri());
            context.setName(LOG_CONTEXT_NAME);
            Logger logger = LogManager.getLogger(Log4jSetup.class);
            if (Thread.getDefaultUncaughtExceptionHandler() == null) {
                Thread.setDefaultUncaughtExceptionHandler((thread, e) -> logger.error(LogMarker.EXCEPTION.getMarker(), "exception on thread {}", (Object)thread.getName(), (Object)e));
            }
            if ((factory = LogManager.getFactory()) instanceof Log4jContextFactory) {
                Log4jContextFactory contextFactory = (Log4jContextFactory)factory;
                ((DefaultShutdownCallbackRegistry)contextFactory.getShutdownCallbackRegistry()).stop();
                Runtime.getRuntime().addShutdownHook(((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("browser")).setThreadName("shutdown-hook")).setRunnable(() -> {
                    logger.info(LogMarker.STARTUP.getMarker(), "JVM is shutting down.");
                    LogManager.shutdown();
                }).build());
            }
        }
        catch (Exception e2) {
            LogManager.getLogger(Log4jSetup.class).fatal("Unable to load log context", (Throwable)e2);
            System.err.println("FATAL Unable to load log context: " + e2);
        }
        log4jLoadedLatch.countDown();
    }

    public static CountDownLatch startLoggingFramework(@Nullable Path configPath) {
        CountDownLatch log4jLoadedLatch = new CountDownLatch(1);
        if (configPath != null && Files.exists(configPath, new LinkOption[0])) {
            new Thread(() -> Log4jSetup.startLog4j(configPath, log4jLoadedLatch)).start();
        } else {
            log4jLoadedLatch.countDown();
        }
        return log4jLoadedLatch;
    }
}

