/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.RunningHashable;
import com.swirlds.common.stream.QueueThreadObjectStreamConfiguration;
import com.swirlds.common.stream.internal.LinkedObjectStream;
import com.swirlds.common.threading.framework.QueueThread;
import com.swirlds.common.threading.framework.config.QueueThreadConfiguration;
import com.swirlds.logging.legacy.LogMarker;
import java.util.Queue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueueThreadObjectStream<T extends RunningHashable>
implements LinkedObjectStream<T> {
    private static final Logger logger = LogManager.getLogger(QueueThreadObjectStream.class);
    private final LinkedObjectStream<T> nextStream;
    private final QueueThread<T> queueThread;

    QueueThreadObjectStream(QueueThreadObjectStreamConfiguration<T> configuration) {
        this.nextStream = configuration.getForwardTo();
        this.queueThread = ((QueueThreadConfiguration)configuration.getQueueThreadConfiguration().setHandler(this::handle)).build();
    }

    @Override
    public void setRunningHash(Hash hash) {
        this.nextStream.setRunningHash(hash);
    }

    private final void handle(T item) {
        this.nextStream.addObject(item);
    }

    @Override
    public void addObject(T t) {
        try {
            this.queueThread.put(t);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "interrupted while attempting to add object to stream");
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void clear() {
        this.queueThread.clear();
        this.nextStream.clear();
    }

    @Override
    public void close() {
        this.queueThread.stop();
        this.nextStream.close();
    }

    public void start() {
        this.queueThread.start();
    }

    public void pause() throws InterruptedException {
        this.queueThread.pause();
    }

    public void resume() {
        this.queueThread.resume();
    }

    public void join() throws InterruptedException {
        this.queueThread.join();
    }

    public void join(long millis) throws InterruptedException {
        this.queueThread.join(millis);
    }

    public void join(long millis, int nanos) throws InterruptedException {
        this.queueThread.join(millis, nanos);
    }

    public void stop() {
        this.queueThread.stop();
    }

    public void interrupt() {
        this.queueThread.interrupt();
    }

    public boolean isAlive() {
        return this.queueThread.isAlive();
    }

    public Queue<T> getQueue() {
        return this.queueThread;
    }
}

