/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system;

import com.swirlds.common.system.SystemExitCode;
import com.swirlds.common.utility.StackTrace;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.SystemExitPayload;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SystemExitUtils {
    private static final Logger logger = LogManager.getLogger(SystemExitUtils.class);

    private SystemExitUtils() {
    }

    public static void exitSystem(@NonNull SystemExitCode suppliedExitCode, @Nullable String message, boolean haltRuntime) {
        SystemExitCode exitCode = suppliedExitCode == null ? SystemExitCode.NO_EXIT_CODE : suppliedExitCode;
        StackTrace stackTrace = StackTrace.getStackTrace();
        String exitMessage = "System exit requested (" + exitCode + ")" + (String)(message == null ? "" : "\nmessage: " + message) + "\nthread requesting exit: " + Thread.currentThread().getName() + "\n" + stackTrace;
        logger.info(LogMarker.STARTUP.getMarker(), exitMessage);
        if (exitCode.isError()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), (Object)new SystemExitPayload(exitCode.name(), exitCode.getExitCode()));
        } else {
            logger.info(LogMarker.STARTUP.getMarker(), (Object)new SystemExitPayload(exitCode.name(), exitCode.getExitCode()));
        }
        System.out.println("Exiting System (" + exitCode.name() + ")");
        System.exit(exitCode.getExitCode());
        if (haltRuntime) {
            Runtime.getRuntime().halt(exitCode.getExitCode());
        }
    }

    public static void exitSystem(@NonNull SystemExitCode exitCode, @Nullable String message) {
        SystemExitUtils.exitSystem(exitCode, message, false);
    }

    public static void exitSystem(@NonNull SystemExitCode exitCode) {
        SystemExitUtils.exitSystem(exitCode, null, false);
    }
}

