/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.address;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.crypto.SerializablePublicKey;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.utility.NonCryptographicHashing;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Objects;

public class Address
implements SelfSerializable {
    private static final long CLASS_ID = 408980092978607982L;
    private static final byte[] ALL_INTERFACES = new byte[]{0, 0, 0, 0};
    private static final int MAX_IP_LENGTH = 16;
    private static final int STRING_MAX_BYTES = 512;
    private NodeId id;
    private String nickname;
    private String selfName;
    private long weight;
    private String hostnameInternal;
    private int portInternal;
    private String hostnameExternal;
    private int portExternal;
    private SerializablePublicKey sigPublicKey;
    private SerializablePublicKey encPublicKey;
    private SerializablePublicKey agreePublicKey;
    private String memo;

    public Address() {
        this(NodeId.FIRST_NODE_ID, "", "", 1L, null, -1, null, -1, null, null, null, "");
    }

    public Address(@NonNull NodeId id, @NonNull String nickname, @NonNull String selfName, long weight, @Nullable String hostnameInternal, int portInternal, @Nullable String hostnameExternal, int portExternal, @NonNull String memo) {
        this(id, nickname, selfName, weight, hostnameInternal, portInternal, hostnameExternal, portExternal, null, null, null, memo);
    }

    private byte[] clone(byte[] x) {
        return x == null ? x : (byte[])x.clone();
    }

    public Address(@NonNull NodeId id, @NonNull String nickname, @NonNull String selfName, long weight, @Nullable String hostnameInternal, int portInternal, @Nullable String hostnameExternal, int portExternal, @Nullable SerializablePublicKey sigPublicKey, @Nullable SerializablePublicKey encPublicKey, @Nullable SerializablePublicKey agreePublicKey, @NonNull String memo) {
        this.id = Objects.requireNonNull(id, "id must not be null");
        this.nickname = Objects.requireNonNull(nickname, "nickname must not be null");
        this.selfName = Objects.requireNonNull(selfName, "selfName must not be null");
        this.weight = weight;
        this.portInternal = portInternal;
        this.portExternal = portExternal;
        this.hostnameInternal = hostnameInternal;
        this.hostnameExternal = hostnameExternal;
        this.sigPublicKey = sigPublicKey;
        this.encPublicKey = encPublicKey;
        this.agreePublicKey = agreePublicKey;
        this.memo = Objects.requireNonNull(memo, "memo must not be null");
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 3;
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Override
    public long getClassId() {
        return 408980092978607982L;
    }

    public long getWeight() {
        return this.weight;
    }

    public boolean isZeroWeight() {
        return this.weight == 0L;
    }

    @NonNull
    public NodeId getNodeId() {
        return this.id;
    }

    @NonNull
    public String getNickname() {
        return this.nickname;
    }

    @NonNull
    public String getSelfName() {
        return this.selfName;
    }

    public int getConnectPort(Address a) {
        return this.isLocalTo(a) ? this.getPortInternal() : this.getPortExternal();
    }

    public boolean isLocalTo(Address a) {
        return Objects.equals(this.getHostnameExternal(), a.getHostnameExternal());
    }

    @NonNull
    public byte[] getListenAddressIpv4() {
        return ALL_INTERFACES;
    }

    public int getListenPort() {
        return this.getPortInternal();
    }

    public int getPortInternal() {
        return this.portInternal;
    }

    public int getPortExternal() {
        return this.portExternal;
    }

    @Nullable
    public String getHostnameInternal() {
        return this.hostnameInternal;
    }

    @Nullable
    public String getHostnameExternal() {
        return this.hostnameExternal;
    }

    @Nullable
    public PublicKey getSigPublicKey() {
        return this.sigPublicKey.getPublicKey();
    }

    @Nullable
    public PublicKey getEncPublicKey() {
        return this.encPublicKey.getPublicKey();
    }

    @Nullable
    public PublicKey getAgreePublicKey() {
        return this.agreePublicKey.getPublicKey();
    }

    @NonNull
    public String getMemo() {
        return this.memo;
    }

    @NonNull
    public Address copySetNodeId(@NonNull NodeId id) {
        Objects.requireNonNull(id, "id must not be null");
        Address a = this.copy();
        a.id = id;
        return a;
    }

    @NonNull
    public Address copySetWeight(long weight) {
        Address a = this.copy();
        a.weight = weight;
        return a;
    }

    @NonNull
    public Address copySetNickname(@NonNull String nickname) {
        Objects.requireNonNull(nickname, "nickname must not be null");
        Address a = this.copy();
        a.nickname = nickname;
        return a;
    }

    @NonNull
    public Address copySetSelfName(@NonNull String selfName) {
        Objects.requireNonNull(selfName, "selfName must not be null");
        Address a = this.copy();
        a.selfName = selfName;
        return a;
    }

    @NonNull
    public Address copySetPortInternal(int portInternal) {
        Address a = this.copy();
        a.portInternal = portInternal;
        return a;
    }

    @NonNull
    public Address copySetPortExternal(int portExternal) {
        Address a = this.copy();
        a.portExternal = portExternal;
        return a;
    }

    @NonNull
    public Address copySetHostnameInternal(@NonNull String hostnameInternal) {
        Objects.requireNonNull(hostnameInternal, "hostnameInternal must not be null");
        Address a = this.copy();
        a.hostnameInternal = hostnameInternal;
        return a;
    }

    @NonNull
    public Address copySetHostnameExternal(@NonNull String hostnameExternal) {
        Objects.requireNonNull(hostnameExternal, "hostnameExternal must not be null");
        Address a = this.copy();
        a.hostnameExternal = hostnameExternal;
        return a;
    }

    @NonNull
    public Address copySetSigPublicKey(@NonNull PublicKey sigPublicKey) {
        Objects.requireNonNull(sigPublicKey, "sigPublicKey must not be null");
        Address a = this.copy();
        a.sigPublicKey = new SerializablePublicKey(sigPublicKey);
        return a;
    }

    @NonNull
    public Address copySetEncPublicKey(@NonNull PublicKey encPublicKey) {
        Objects.requireNonNull(encPublicKey, "encPublicKey must not be null");
        Address a = this.copy();
        a.encPublicKey = new SerializablePublicKey(encPublicKey);
        return a;
    }

    @NonNull
    public Address copySetAgreePublicKey(@NonNull PublicKey agreePublicKey) {
        Objects.requireNonNull(agreePublicKey, "agreePublicKey must not be null");
        Address a = this.copy();
        a.agreePublicKey = new SerializablePublicKey(agreePublicKey);
        return a;
    }

    @NonNull
    public Address copySetMemo(@NonNull String memo) {
        Objects.requireNonNull(memo, "memo must not be null");
        Address a = this.copy();
        a.memo = memo;
        return a;
    }

    public Address copy() {
        return new Address(this.id, this.nickname, this.selfName, this.weight, this.hostnameInternal, this.portInternal, this.hostnameExternal, this.portExternal, this.sigPublicKey, this.encPublicKey, this.agreePublicKey, this.memo);
    }

    @Override
    public void serialize(SerializableDataOutputStream outStream) throws IOException {
        outStream.writeSerializable(this.id, false);
        outStream.writeNormalisedString(this.nickname);
        outStream.writeNormalisedString(this.selfName);
        outStream.writeLong(this.weight);
        outStream.writeNormalisedString(this.hostnameInternal);
        outStream.writeInt(this.portInternal);
        outStream.writeNormalisedString(this.hostnameExternal);
        outStream.writeInt(this.portExternal);
        outStream.writeSerializable(this.sigPublicKey, false);
        outStream.writeSerializable(this.encPublicKey, false);
        outStream.writeSerializable(this.agreePublicKey, false);
        outStream.writeNormalisedString(this.memo);
    }

    @Override
    public void deserialize(SerializableDataInputStream inStream, int version) throws IOException {
        this.id = version < 4 ? new NodeId(inStream.readLong()) : inStream.readSerializable(false, NodeId::new);
        this.nickname = inStream.readNormalisedString(512);
        this.selfName = inStream.readNormalisedString(512);
        this.weight = inStream.readLong();
        this.hostnameInternal = version < 5 ? Address.ipString(inStream.readByteArray(16)) : inStream.readNormalisedString(16);
        this.portInternal = inStream.readInt();
        this.hostnameExternal = version < 5 ? Address.ipString(inStream.readByteArray(16)) : inStream.readNormalisedString(16);
        this.portExternal = inStream.readInt();
        if (version < 5) {
            inStream.readByteArray(16);
            inStream.readInt();
            inStream.readByteArray(16);
            inStream.readInt();
        }
        switch (version) {
            case 1: {
                this.sigPublicKey = new SerializablePublicKey();
                this.encPublicKey = new SerializablePublicKey();
                this.agreePublicKey = new SerializablePublicKey();
                this.sigPublicKey.deserializeVersion0(inStream, "RSA");
                this.encPublicKey.deserializeVersion0(inStream, "EC");
                this.agreePublicKey.deserializeVersion0(inStream, "EC");
                break;
            }
            case 2: {
                this.sigPublicKey = new SerializablePublicKey();
                this.encPublicKey = new SerializablePublicKey();
                this.agreePublicKey = new SerializablePublicKey();
                this.sigPublicKey.deserialize(inStream, 1);
                this.encPublicKey.deserialize(inStream, 1);
                this.agreePublicKey.deserialize(inStream, 1);
                break;
            }
            default: {
                this.sigPublicKey = inStream.readSerializable(false, SerializablePublicKey::new);
                this.encPublicKey = inStream.readSerializable(false, SerializablePublicKey::new);
                this.agreePublicKey = inStream.readSerializable(false, SerializablePublicKey::new);
            }
        }
        this.memo = inStream.readNormalisedString(512);
    }

    public static String ipString(byte[] ip) {
        return (0xFF & ip[0]) + "." + (0xFF & ip[1]) + "." + (0xFF & ip[2]) + "." + (0xFF & ip[3]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.equalsWithoutWeight(address) && this.weight == address.weight;
    }

    public boolean equalsWithoutWeight(@NonNull Address address) {
        return Objects.equals(this.id, address.id) && this.portInternal == address.portInternal && this.portExternal == address.portExternal && Objects.equals(this.nickname, address.nickname) && Objects.equals(this.selfName, address.selfName) && Objects.equals(this.hostnameInternal, address.hostnameInternal) && Objects.equals(this.hostnameExternal, address.hostnameExternal) && Arrays.equals(this.sigPublicKey.getPublicKey().getEncoded(), address.sigPublicKey.getPublicKey().getEncoded()) && Arrays.equals(this.encPublicKey.getPublicKey().getEncoded(), address.encPublicKey.getPublicKey().getEncoded()) && Arrays.equals(this.agreePublicKey.getPublicKey().getEncoded(), address.agreePublicKey.getPublicKey().getEncoded()) && Objects.equals(this.memo, address.memo);
    }

    public int hashCode() {
        return NonCryptographicHashing.hash32(this.id.id());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("nickname", (Object)this.nickname).append("selfName", (Object)this.selfName).append("weight", (Object)this.weight).append("hostnameInternal", (Object)this.hostnameInternal).append("portInternalIpv4", (Object)this.portInternal).append("hostnameExternal", (Object)this.hostnameExternal).append("portExternalIpv4", (Object)this.portExternal).append("sigPublicKey", (Object)this.sigPublicKey).append("encPublicKey", (Object)this.encPublicKey).append("agreePublicKey", (Object)this.agreePublicKey).append("memo", (Object)this.memo).toString();
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 3;
        public static final int SELF_SERIALIZABLE_NODE_ID = 4;
        public static final int ADD_DNS_SUPPORT = 5;

        private ClassVersion() {
        }
    }
}

