/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.events;

import com.swirlds.common.system.NodeId;
import com.swirlds.common.system.SoftwareVersion;
import com.swirlds.common.system.transaction.Transaction;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Iterator;
import java.util.function.Consumer;

public interface Event {
    public Iterator<Transaction> transactionIterator();

    public Instant getTimeCreated();

    @NonNull
    public NodeId getCreatorId();

    public Instant getEstimatedTime();

    default public void forEachTransaction(Consumer<Transaction> consumer) {
        Iterator<Transaction> transIt = this.transactionIterator();
        while (transIt.hasNext()) {
            consumer.accept(transIt.next());
        }
    }

    @Nullable
    public SoftwareVersion getSoftwareVersion();
}

