/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.events;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.NodeId;
import com.swirlds.common.utility.CommonUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;

public class EventDescriptor
implements SelfSerializable {
    public static final long CLASS_ID = -9052771871267871386L;
    private Hash hash;
    private NodeId creator;
    private long generation;

    public EventDescriptor() {
    }

    public EventDescriptor(@NonNull Hash hash, @NonNull NodeId creator, long generation) {
        this.hash = Objects.requireNonNull(hash, "hash must not be null");
        this.creator = Objects.requireNonNull(creator, "creator must not be null");
        this.generation = generation;
    }

    @NonNull
    public Hash getHash() {
        if (this.hash == null) {
            throw new IllegalStateException("EventDescriptor improperly initialized: the hash is null");
        }
        return this.hash;
    }

    @NonNull
    public NodeId getCreator() {
        if (this.hash == null) {
            throw new IllegalStateException("EventDescriptor improperly initialized: the hash is null");
        }
        return this.creator;
    }

    public long getGeneration() {
        return this.generation;
    }

    @Override
    public long getClassId() {
        return -9052771871267871386L;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        out.writeSerializable(this.hash, false);
        out.writeSerializable(this.creator, false);
        out.writeLong(this.generation);
    }

    @Override
    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        this.hash = in.readSerializable(false, Hash::new);
        if (this.hash == null) {
            throw new IOException("hash cannot be null");
        }
        if (version < 2) {
            this.creator = new NodeId(in.readLong());
        } else {
            this.creator = in.readSerializable(false, NodeId::new);
            if (this.creator == null) {
                throw new IOException("creator cannot be null");
            }
        }
        this.generation = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventDescriptor that = (EventDescriptor)o;
        return Objects.equals(this.creator, that.creator) && this.generation == that.generation && this.hash.equals(that.hash);
    }

    public int hashCode() {
        if (this.hash == null) {
            throw new IllegalStateException("EventDescriptor improperly initialized: the hash is null");
        }
        return this.hash.hashCode();
    }

    public String toString() {
        return "(creator: " + this.creator + ", generation: " + this.generation + ", hash: " + CommonUtils.hex(this.hash.getValue()).substring(0, 12) + ")";
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int SELF_SERIALIZABLE_NODE_ID = 2;

        private ClassVersion() {
        }
    }
}

