/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.transaction.internal;

import com.swirlds.common.config.TransactionConfig;
import com.swirlds.common.config.singleton.ConfigurationHolder;
import com.swirlds.common.io.streams.AugmentedDataOutputStream;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.transaction.SystemTransactionType;
import com.swirlds.common.system.transaction.internal.SystemTransaction;
import java.io.IOException;
import java.util.Arrays;

public final class SystemTransactionPing
extends SystemTransaction {
    private static final long PING_CLASS_ID = -1617568331113798073L;
    private static final int PING_CLASS_VERSION = 1;
    private int[] avgPingMilliseconds;

    public SystemTransactionPing() {
    }

    public SystemTransactionPing(int[] avgPingMilliseconds) {
        this.avgPingMilliseconds = avgPingMilliseconds;
    }

    public int[] getAvgPingMilliseconds() {
        return this.avgPingMilliseconds;
    }

    @Override
    public int getSize() {
        return this.getSerializedLength();
    }

    @Override
    public SystemTransactionType getType() {
        return SystemTransactionType.SYS_TRANS_PING_MICROSECONDS;
    }

    @Override
    public void serialize(SerializableDataOutputStream dos) throws IOException {
        dos.writeIntArray(this.avgPingMilliseconds);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        TransactionConfig transactionConfig = ConfigurationHolder.getConfigData(TransactionConfig.class);
        this.avgPingMilliseconds = in.readIntArray(transactionConfig.maxAddressSizeAllowed());
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 1;
    }

    @Override
    public long getClassId() {
        return -1617568331113798073L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getSerializedLength() {
        return AugmentedDataOutputStream.getArraySerializedLength(this.avgPingMilliseconds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemTransactionPing that = (SystemTransactionPing)o;
        return Arrays.equals(this.avgPingMilliseconds, that.avgPingMilliseconds);
    }

    public int hashCode() {
        return Arrays.hashCode(this.avgPingMilliseconds);
    }
}

