/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import com.swirlds.common.utility.CompareTo;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongBinaryOperator;

public class CountUpLatch {
    private final AtomicLong currentCount;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private static final LongBinaryOperator SET_COUNT = (previous, proposed) -> Math.max(proposed, previous);

    public CountUpLatch() {
        this(0L);
    }

    public CountUpLatch(long initialCount) {
        this.currentCount = new AtomicLong(initialCount);
    }

    public long getCount() {
        return this.currentCount.get();
    }

    public void increment() {
        this.add(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(long count) {
        long result = this.currentCount.accumulateAndGet(count, SET_COUNT);
        if (result != count) {
            throw new IllegalArgumentException("Can't set the count to a lower value. Previous = " + result + ", provided = " + count);
        }
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void add(long delta) {
        if (delta < 0L) {
            throw new IllegalArgumentException("Cannot add a negative delta (" + delta + ")");
        }
        this.currentCount.addAndGet(delta);
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void await(long count) throws InterruptedException {
        while (this.currentCount.get() < count) {
            this.lock.lock();
            try {
                if (this.currentCount.get() >= count) {
                    return;
                }
                this.condition.await();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private static Duration getRemainingTime(Instant start, Duration timeToWait) {
        Instant now = Instant.now();
        Duration elapsed = Duration.between(start, now);
        if (CompareTo.isLessThan(timeToWait, elapsed)) {
            return Duration.ZERO;
        }
        return timeToWait.minus(elapsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long count, Duration timeToWait) throws InterruptedException {
        Instant start = Instant.now();
        while (this.currentCount.get() < count) {
            long remainingMillis = CountUpLatch.getRemainingTime(start, timeToWait).toMillis();
            if (remainingMillis <= 0L) {
                return this.currentCount.get() >= count;
            }
            this.lock.lock();
            try {
                if (this.currentCount.get() >= count) {
                    boolean bl = true;
                    return bl;
                }
                this.condition.await(remainingMillis, TimeUnit.MILLISECONDS);
            }
            finally {
                this.lock.unlock();
            }
        }
        return true;
    }
}

