/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.futures;

import com.swirlds.common.exceptions.PlatformException;
import com.swirlds.logging.legacy.LogMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class ConcurrentFuturePool<V>
extends ConcurrentLinkedQueue<Future<V>> {
    private final Consumer<Exception> exceptionHandler;
    private static volatile boolean shuttingDown = false;

    public ConcurrentFuturePool() {
        this.exceptionHandler = null;
    }

    public ConcurrentFuturePool(Consumer<Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public ConcurrentFuturePool(Collection<? extends Future<V>> c) {
        super(c);
        this.exceptionHandler = null;
    }

    public ConcurrentFuturePool(Collection<? extends Future<V>> c, Consumer<Exception> exceptionHandler) {
        super(c);
        this.exceptionHandler = exceptionHandler;
    }

    public ConcurrentFuturePool(SortedSet<Future<V>> s) {
        super(s);
        this.exceptionHandler = null;
    }

    public ConcurrentFuturePool(SortedSet<Future<V>> s, Consumer<Exception> exceptionHandler) {
        super(s);
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isComplete() {
        this.removeIf(v -> v.isDone() || v.isCancelled());
        return this.size() == 0;
    }

    private static boolean isShuttingDown() {
        return shuttingDown;
    }

    public List<V> waitForCompletion() {
        ArrayList results = new ArrayList(this.size());
        this.forEach((? super E f) -> {
            block6: {
                if (f.isCancelled()) {
                    results.add(null);
                    return;
                }
                try {
                    results.add(f.get());
                }
                catch (InterruptedException | ExecutionException ex) {
                    if (this.exceptionHandler != null) {
                        if (!ConcurrentFuturePool.isShuttingDown()) {
                            this.exceptionHandler.accept(ex);
                        }
                    }
                    if (ConcurrentFuturePool.isShuttingDown()) break block6;
                    if (ex instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new PlatformException(ex, LogMarker.EXCEPTION);
                }
            }
        });
        return results;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            shuttingDown = true;
        }));
    }
}

