/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility.throttle;

import com.swirlds.base.time.Time;
import com.swirlds.common.threading.locks.AutoClosableLock;
import com.swirlds.common.threading.locks.Locks;
import com.swirlds.common.threading.locks.locked.Locked;
import com.swirlds.common.utility.throttle.RateLimiter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;

public class RateLimitedLogger {
    private final Logger logger;
    private final RateLimiter rateLimiter;
    private final AutoClosableLock lock;

    public RateLimitedLogger(@NonNull Logger logger, @NonNull Time time, double maxFrequency) {
        this(logger, new RateLimiter(time, maxFrequency));
    }

    public RateLimitedLogger(@NonNull Logger logger, @NonNull Time time, @NonNull Duration minimumPeriod) {
        this(logger, new RateLimiter(time, minimumPeriod));
    }

    private RateLimitedLogger(@NonNull Logger logger, @NonNull RateLimiter rateLimiter) {
        this.logger = Objects.requireNonNull(logger);
        this.rateLimiter = Objects.requireNonNull(rateLimiter);
        this.lock = Locks.createAutoLock();
    }

    @NonNull
    private static String generateMessage(@NonNull String baseMessage, long deniedRequests) {
        if (deniedRequests > 0L) {
            return baseMessage + "\n(Due to rate limiting, this condition has been triggered " + deniedRequests + " times without being reported.)";
        }
        return baseMessage;
    }

    public void log(@NonNull Level level, @NonNull Marker logMarker, @NonNull String message, Object ... varargs) {
        Objects.requireNonNull(level);
        Objects.requireNonNull(logMarker);
        Objects.requireNonNull(message);
        try (Locked l = this.lock.lock();){
            long deniedRequests = this.rateLimiter.getDeniedRequests();
            if (this.rateLimiter.requestAndTrigger()) {
                this.logger.log(level, logMarker, RateLimitedLogger.generateMessage(message, deniedRequests), varargs);
            }
        }
    }

    public void debug(@NonNull Marker logMarker, @NonNull String message, Object ... varargs) {
        this.log(Level.DEBUG, logMarker, message, varargs);
    }

    public void trace(@NonNull Marker logMarker, @NonNull String message, Object ... varargs) {
        this.log(Level.TRACE, logMarker, message, varargs);
    }

    public void info(@NonNull Marker logMarker, @NonNull String message, Object ... varargs) {
        this.log(Level.INFO, logMarker, message, varargs);
    }

    public void warn(@NonNull Marker logMarker, @NonNull String message, Object ... varargs) {
        this.log(Level.WARN, logMarker, message, varargs);
    }

    public void error(@NonNull Marker logMarker, @NonNull String message, Object ... varargs) {
        this.log(Level.ERROR, logMarker, message, varargs);
    }

    public void fatal(@NonNull Marker logMarker, @NonNull String message, Object ... varargs) {
        this.log(Level.FATAL, logMarker, message, varargs);
    }
}

