/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility.throttle;

import com.swirlds.base.time.Time;
import com.swirlds.common.utility.CompareTo;
import java.time.Duration;
import java.time.Instant;

public class RateLimiter {
    private final Duration minimumPeriod;
    private Instant lastOperation = Instant.EPOCH;
    private long deniedRequests;
    private final Time time;

    public RateLimiter(Time time, Duration minimumPeriod) {
        this.time = time;
        this.minimumPeriod = minimumPeriod;
    }

    public RateLimiter(Time time, double maxFrequency) {
        this(time, Duration.ofNanos((long)(1.0 / maxFrequency * 1.0E9)));
    }

    public boolean requestAndTrigger() {
        Instant now = this.time.now();
        Duration elapsed = Duration.between(this.lastOperation, now);
        if (CompareTo.isGreaterThanOrEqualTo(elapsed, this.minimumPeriod)) {
            this.lastOperation = now;
            this.deniedRequests = 0L;
            return true;
        }
        ++this.deniedRequests;
        return false;
    }

    public boolean request() {
        Instant now = this.time.now();
        Duration elapsed = Duration.between(this.lastOperation, now);
        if (CompareTo.isGreaterThanOrEqualTo(elapsed, this.minimumPeriod)) {
            this.deniedRequests = 0L;
            return true;
        }
        ++this.deniedRequests;
        return false;
    }

    public void trigger() {
        this.deniedRequests = 0L;
        this.lastOperation = this.time.now();
    }

    public long getDeniedRequests() {
        return this.deniedRequests;
    }
}

