/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.counters;

import com.swirlds.common.wiring.counters.ObjectCounter;
import java.util.Objects;

public class MultiObjectCounter
extends ObjectCounter {
    private final ObjectCounter[] counters;

    public MultiObjectCounter(ObjectCounter ... counters) {
        this.counters = Objects.requireNonNull(counters);
        if (counters.length == 0) {
            throw new IllegalArgumentException("Must have at least one counter");
        }
    }

    @Override
    public void onRamp() {
        for (ObjectCounter counter : this.counters) {
            counter.onRamp();
        }
    }

    @Override
    public boolean attemptOnRamp() {
        boolean success = this.counters[0].attemptOnRamp();
        if (!success) {
            return false;
        }
        for (int i = 1; i < this.counters.length; ++i) {
            this.counters[i].forceOnRamp();
        }
        return true;
    }

    @Override
    public void forceOnRamp() {
        for (ObjectCounter counter : this.counters) {
            counter.forceOnRamp();
        }
    }

    @Override
    public void offRamp() {
        for (ObjectCounter counter : this.counters) {
            counter.offRamp();
        }
    }

    @Override
    public long getCount() {
        return this.counters[0].getCount();
    }

    @Override
    public void waitUntilEmpty() {
        for (ObjectCounter counter : this.counters) {
            counter.waitUntilEmpty();
        }
    }
}

