/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.counters;

import com.swirlds.common.wiring.counters.EmptyBlocker;
import com.swirlds.common.wiring.counters.ObjectCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicLong;

public class StandardObjectCounter
extends ObjectCounter {
    private final AtomicLong count = new AtomicLong(0L);
    private final ForkJoinPool.ManagedBlocker waitUntilEmptyBlocker;

    public StandardObjectCounter(@NonNull Duration sleepDuration) {
        long sleepNanos = sleepDuration.toNanos();
        this.waitUntilEmptyBlocker = new EmptyBlocker(this.count, sleepNanos);
    }

    @Override
    public void onRamp() {
        this.count.incrementAndGet();
    }

    @Override
    public boolean attemptOnRamp() {
        this.count.getAndIncrement();
        return true;
    }

    @Override
    public void forceOnRamp() {
        this.count.getAndIncrement();
    }

    @Override
    public void offRamp() {
        this.count.decrementAndGet();
    }

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public void waitUntilEmpty() {
        if (this.count.get() == 0L) {
            return;
        }
        try {
            ForkJoinPool.managedBlock(this.waitUntilEmptyBlocker);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while blocking on an waitUntilEmpty()");
        }
    }
}

