/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.model;

import com.swirlds.base.state.Startable;
import com.swirlds.base.state.Stoppable;
import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.wiring.model.ModelGroup;
import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerBuilder;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerMetricsBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;

public interface WiringModel
extends Startable,
Stoppable {
    @NonNull
    public static WiringModel create(@NonNull PlatformContext platformContext, @NonNull Time time) {
        return new StandardWiringModel(platformContext.getMetrics(), time);
    }

    @NonNull
    public static WiringModel create(@NonNull Metrics metrics, @NonNull Time time) {
        return new StandardWiringModel(metrics, time);
    }

    @NonNull
    public <O> TaskSchedulerBuilder<O> schedulerBuilder(@NonNull String var1);

    @NonNull
    public TaskSchedulerMetricsBuilder metricsBuilder();

    public boolean checkForCyclicalBackpressure();

    public boolean checkForIllegalDirectSchedulerUsage();

    public boolean checkForUnboundInputWires();

    @NonNull
    public String generateWiringDiagram(@NonNull Set<ModelGroup> var1);

    public void start();

    public void stop();
}

