/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.model.internal;

import com.swirlds.common.utility.NonCryptographicHashing;
import com.swirlds.common.wiring.model.internal.ModelVertex;
import edu.umd.cs.findbugs.annotations.NonNull;

public record ModelEdge(@NonNull ModelVertex source, @NonNull ModelVertex destination, @NonNull String label, boolean insertionIsBlocking) implements Comparable<ModelEdge>
{
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ModelEdge) {
            ModelEdge that = (ModelEdge)obj;
            return this.source.equals(that.source) && this.destination.equals(that.destination) && this.label.equals(that.label);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return NonCryptographicHashing.hash32((long)this.source.hashCode(), (long)this.destination.hashCode(), (long)this.label.hashCode());
    }

    @Override
    public String toString() {
        return this.source + " --" + this.label + "-->" + (this.insertionIsBlocking ? "" : ">") + " " + this.destination;
    }

    @Override
    public int compareTo(@NonNull ModelEdge that) {
        if (!this.source.equals(that.source)) {
            return this.source.compareTo(that.source);
        }
        if (!this.destination.equals(that.destination)) {
            return this.destination.compareTo(that.destination);
        }
        return this.label.compareTo(that.label);
    }
}

