/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.model.internal;

import com.swirlds.common.wiring.model.internal.ModelEdge;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class ModelVertex
implements Iterable<ModelEdge>,
Comparable<ModelVertex> {
    private final String name;
    private final boolean insertionIsBlocking;
    private final TaskSchedulerType type;
    private final List<ModelEdge> outgoingEdges = new ArrayList<ModelEdge>();

    public ModelVertex(@NonNull String name, @NonNull TaskSchedulerType type, boolean insertionIsBlocking) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.insertionIsBlocking = insertionIsBlocking;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public TaskSchedulerType getType() {
        return this.type;
    }

    public boolean isInsertionIsBlocking() {
        return this.insertionIsBlocking;
    }

    public void connectToEdge(@NonNull ModelEdge vertex) {
        this.outgoingEdges.add(Objects.requireNonNull(vertex));
    }

    @Override
    @NonNull
    public Iterator<ModelEdge> iterator() {
        return this.outgoingEdges.iterator();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof ModelVertex) {
            ModelVertex that = (ModelVertex)obj;
            return this.name.equals(that.name);
        }
        return false;
    }

    public String toString() {
        if (this.insertionIsBlocking) {
            return "[" + this.name + "]";
        }
        return "(" + this.name + ")";
    }

    @Override
    public int compareTo(@NonNull ModelVertex that) {
        return this.name.compareTo(that.name);
    }
}

