/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.model.internal;

import com.swirlds.common.wiring.model.ModelGroup;
import com.swirlds.common.wiring.model.internal.ModelEdge;
import com.swirlds.common.wiring.model.internal.ModelVertex;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class WiringFlowchart {
    private static final String INDENTATION = "    ";
    private static final String SCHEDULER_COLOR = "ff9";
    private static final String DIRECT_SCHEDULER_COLOR = "ccc";
    private static final String TEXT_COLOR = "000";
    private static final String GROUP_COLOR = "9cf";

    private WiringFlowchart() {
    }

    private static void drawEdge(@NonNull StringBuilder sb, @NonNull ModelEdge edge, @NonNull Map<ModelVertex, String> collapsedVertexMap) {
        String destination;
        String source = collapsedVertexMap.containsKey(edge.source()) ? collapsedVertexMap.get(edge.source()) : edge.source().getName();
        if (source.equals(destination = collapsedVertexMap.containsKey(edge.destination()) ? collapsedVertexMap.get(edge.destination()) : edge.destination().getName())) {
            return;
        }
        sb.append(INDENTATION).append(source);
        if (edge.insertionIsBlocking()) {
            if (edge.label().isEmpty()) {
                sb.append(" --> ");
            } else {
                sb.append(" -- \"").append(edge.label()).append("\" --> ");
            }
        } else if (edge.label().isEmpty()) {
            sb.append(" -.-> ");
        } else {
            sb.append(" -. \"").append(edge.label()).append("\" .-> ");
        }
        sb.append(destination).append("\n");
    }

    private static void modifyVertexShape(@NonNull StringBuilder sb, @NonNull ModelVertex vertex) {
        if (vertex.getType() == TaskSchedulerType.CONCURRENT) {
            sb.append("[[").append(vertex.getName()).append("]]");
        } else if (vertex.getType() == TaskSchedulerType.DIRECT) {
            sb.append("[/").append(vertex.getName()).append("/]");
        } else if (vertex.getType() == TaskSchedulerType.DIRECT_STATELESS) {
            sb.append("{{").append(vertex.getName()).append("}}");
        }
    }

    private static String getVertexColor(@NonNull ModelVertex vertex) {
        TaskSchedulerType type = vertex.getType();
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TaskSchedulerType.SEQUENTIAL, TaskSchedulerType.SEQUENTIAL_THREAD, TaskSchedulerType.CONCURRENT -> SCHEDULER_COLOR;
            case TaskSchedulerType.DIRECT, TaskSchedulerType.DIRECT_STATELESS -> DIRECT_SCHEDULER_COLOR;
        };
    }

    private static void drawVertex(@NonNull StringBuilder sb, @NonNull ModelVertex vertex, @NonNull Map<ModelVertex, String> collapsedVertexMap, int indentLevel) {
        if (!collapsedVertexMap.containsKey(vertex)) {
            sb.append(INDENTATION.repeat(indentLevel)).append(vertex.getName());
            WiringFlowchart.modifyVertexShape(sb, vertex);
            sb.append("\n");
            sb.append(INDENTATION.repeat(indentLevel)).append("style ").append(vertex.getName()).append(" fill:#").append(WiringFlowchart.getVertexColor(vertex)).append(",stroke:#").append(TEXT_COLOR).append(",stroke-width:2px\n");
        }
    }

    private static void drawGroup(@NonNull StringBuilder sb, @NonNull ModelGroup group, @NonNull Set<ModelVertex> vertices, @NonNull Map<ModelVertex, String> collapsedVertexMap) {
        sb.append(INDENTATION).append("subgraph ").append(group.name()).append("\n");
        String color = group.collapse() ? SCHEDULER_COLOR : GROUP_COLOR;
        sb.append(INDENTATION.repeat(2)).append("style ").append(group.name()).append(" fill:#").append(color).append(",stroke:#").append(TEXT_COLOR).append(",stroke-width:2px\n");
        vertices.stream().sorted().forEachOrdered(vertex -> WiringFlowchart.drawVertex(sb, vertex, collapsedVertexMap, 2));
        sb.append(INDENTATION).append("end\n");
    }

    @NonNull
    private static Map<String, Set<ModelVertex>> buildGroupMap(@NonNull Map<String, ModelVertex> vertices, @NonNull Set<ModelGroup> groups) {
        HashMap<String, Set<ModelVertex>> groupMap = new HashMap<String, Set<ModelVertex>>();
        for (ModelGroup group : groups) {
            groupMap.put(group.name(), new HashSet());
            for (String vertexName : group.elements()) {
                ((Set)groupMap.get(group.name())).add(vertices.get(vertexName));
            }
        }
        return groupMap;
    }

    private static List<ModelVertex> getUngroupedVertices(@NonNull Map<String, ModelVertex> vertices, @NonNull Map<String, Set<ModelVertex>> groupMap) {
        HashSet<ModelVertex> uniqueVertices = new HashSet<ModelVertex>(vertices.values());
        for (Set<ModelVertex> group : groupMap.values()) {
            for (ModelVertex vertex : group) {
                boolean removed = uniqueVertices.remove(vertex);
                if (removed) continue;
                throw new IllegalStateException("Vertex " + vertex.getName() + " is in multiple groups.");
            }
        }
        return new ArrayList<ModelVertex>(uniqueVertices);
    }

    @NonNull
    private static Map<ModelVertex, String> getCollapsedVertexMap(@NonNull Set<ModelGroup> groups, @NonNull Map<String, ModelVertex> vertices) {
        HashMap<ModelVertex, String> collapsedVertexMap = new HashMap<ModelVertex, String>();
        for (ModelGroup group : groups) {
            if (!group.collapse()) continue;
            for (String vertexName : group.elements()) {
                collapsedVertexMap.put(vertices.get(vertexName), group.name());
            }
        }
        return collapsedVertexMap;
    }

    @NonNull
    public static String generateWiringDiagram(@NonNull Map<String, ModelVertex> vertices, @NonNull Set<ModelEdge> edges, @NonNull Set<ModelGroup> groups) {
        StringBuilder sb = new StringBuilder();
        sb.append("flowchart LR\n");
        Map<String, Set<ModelVertex>> groupMap = WiringFlowchart.buildGroupMap(vertices, groups);
        List<ModelVertex> ungroupedVertices = WiringFlowchart.getUngroupedVertices(vertices, groupMap);
        Map<ModelVertex, String> collapsedVertexMap = WiringFlowchart.getCollapsedVertexMap(groups, vertices);
        groups.stream().sorted().forEachOrdered(group -> WiringFlowchart.drawGroup(sb, group, (Set)groupMap.get(group.name()), collapsedVertexMap));
        ungroupedVertices.stream().sorted().forEachOrdered(vertex -> WiringFlowchart.drawVertex(sb, vertex, collapsedVertexMap, 1));
        edges.stream().sorted().forEachOrdered(edge -> WiringFlowchart.drawEdge(sb, edge, collapsedVertexMap));
        return sb.toString();
    }
}

