/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.schedulers;

import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.wires.input.Bindable;
import com.swirlds.common.wiring.wires.input.BindableInputWire;
import com.swirlds.common.wiring.wires.input.TaskSchedulerInput;
import com.swirlds.common.wiring.wires.output.OutputWire;
import com.swirlds.common.wiring.wires.output.StandardOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

public abstract class TaskScheduler<OUT>
extends TaskSchedulerInput<OUT> {
    private final boolean flushEnabled;
    private final StandardWiringModel model;
    private final String name;
    private final TaskSchedulerType type;
    private final StandardOutputWire<OUT> primaryOutputWire;
    private final boolean insertionIsBlocking;

    protected TaskScheduler(@NonNull StandardWiringModel model, @NonNull String name, @NonNull TaskSchedulerType type, boolean flushEnabled, boolean insertionIsBlocking) {
        this.model = Objects.requireNonNull(model);
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.flushEnabled = flushEnabled;
        this.primaryOutputWire = new StandardOutputWire(model, name);
        this.insertionIsBlocking = insertionIsBlocking;
    }

    @NonNull
    public final <I> BindableInputWire<I, OUT> buildInputWire(@NonNull String name) {
        return new BindableInputWire(this.model, this, name);
    }

    @NonNull
    public OutputWire<OUT> getOutputWire() {
        return this.primaryOutputWire;
    }

    @NonNull
    public <T> StandardOutputWire<T> buildSecondaryOutputWire() {
        return new StandardOutputWire(this.model, this.name);
    }

    @NonNull
    public Bindable<Instant, OUT> buildHeartbeatInputWire(@NonNull String name, @NonNull Duration period) {
        BindableInputWire inputWire = this.buildInputWire(name);
        this.model.buildHeartbeatWire(period).solderTo(inputWire);
        return inputWire;
    }

    @NonNull
    public Bindable<Instant, OUT> buildHeartbeatInputWire(@NonNull String name, double frequency) {
        BindableInputWire inputWire = this.buildInputWire(name);
        this.model.buildHeartbeatWire(frequency).solderTo(inputWire);
        return inputWire;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public TaskSchedulerType getType() {
        return this.type;
    }

    public boolean isInsertionBlocking() {
        return this.insertionIsBlocking;
    }

    @NonNull
    public final <X> TaskScheduler<X> cast() {
        return this;
    }

    public abstract long getUnprocessedTaskCount();

    public abstract void flush();

    protected final void throwIfFlushDisabled() {
        if (!this.flushEnabled) {
            throw new UnsupportedOperationException("Flushing is not enabled for the task scheduler " + this.name);
        }
    }

    @Override
    protected void forward(@NonNull OUT data) {
        this.primaryOutputWire.forward(data);
    }
}

