/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.schedulers.builders;

import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.common.metrics.MetricConfig;
import com.swirlds.common.metrics.Metrics;
import com.swirlds.common.metrics.extensions.FractionalTimer;
import com.swirlds.common.metrics.extensions.NoOpFractionalTimer;
import com.swirlds.common.metrics.extensions.StandardFractionalTimer;
import com.swirlds.common.wiring.counters.ObjectCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class TaskSchedulerMetricsBuilder {
    private final Metrics metrics;
    private final Time time;
    private boolean unhandledTaskMetricEnabled = false;
    private boolean busyFractionMetricEnabled = false;
    private StandardFractionalTimer busyFractionTimer;

    public TaskSchedulerMetricsBuilder(@NonNull Metrics metrics, @NonNull Time time) {
        this.metrics = Objects.requireNonNull(metrics);
        this.time = Objects.requireNonNull(time);
    }

    @NonNull
    public TaskSchedulerMetricsBuilder withUnhandledTaskMetricEnabled(boolean enabled) {
        this.unhandledTaskMetricEnabled = enabled;
        return this;
    }

    public TaskSchedulerMetricsBuilder withBusyFractionMetricsEnabled(boolean enabled) {
        this.busyFractionMetricEnabled = enabled;
        return this;
    }

    boolean isUnhandledTaskMetricEnabled() {
        return this.unhandledTaskMetricEnabled;
    }

    boolean isBusyFractionMetricEnabled() {
        return this.busyFractionMetricEnabled;
    }

    @NonNull
    FractionalTimer buildBusyTimer() {
        if (this.busyFractionMetricEnabled) {
            this.busyFractionTimer = new StandardFractionalTimer(this.time);
            return this.busyFractionTimer;
        }
        return NoOpFractionalTimer.getInstance();
    }

    void registerMetrics(@NonNull String taskSchedulerName, @Nullable ObjectCounter unhandledTaskCounter) {
        if (this.unhandledTaskMetricEnabled) {
            Objects.requireNonNull(unhandledTaskCounter);
            MetricConfig config = new FunctionGauge.Config<Long>("platform", taskSchedulerName + "_unhandled_task_count", Long.class, unhandledTaskCounter::getCount).withDescription("The number of scheduled tasks that have not been fully handled for the scheduler " + taskSchedulerName);
            this.metrics.getOrCreate(config);
        }
        if (this.busyFractionMetricEnabled) {
            this.busyFractionTimer.registerMetric(this.metrics, "platform", taskSchedulerName + "_busy_fraction", "Fraction (out of 1.0) of time spent processing tasks for the task scheduler " + taskSchedulerName);
        }
    }
}

