/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.schedulers.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractTask
extends ForkJoinTask<Void> {
    private final AtomicInteger dependencyCount;
    private final ForkJoinPool pool;

    protected AbstractTask(@NonNull ForkJoinPool pool, int dependencyCount) {
        this.pool = pool;
        this.dependencyCount = dependencyCount > 0 ? new AtomicInteger(dependencyCount) : null;
    }

    @Override
    public final Void getRawResult() {
        return null;
    }

    @Override
    protected final void setRawResult(Void value) {
    }

    protected void send() {
        if (this.dependencyCount == null || this.dependencyCount.decrementAndGet() == 0) {
            this.pool.execute(this);
        }
    }

    @Override
    protected abstract boolean exec();
}

