/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.schedulers.internal;

import com.swirlds.common.wiring.counters.ObjectCounter;
import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.TaskScheduler;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.schedulers.internal.ConcurrentTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;

public class ConcurrentTaskScheduler<OUT>
extends TaskScheduler<OUT> {
    private final ObjectCounter onRamp;
    private final ObjectCounter offRamp;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final ForkJoinPool pool;

    public ConcurrentTaskScheduler(@NonNull StandardWiringModel model, @NonNull String name, @NonNull ForkJoinPool pool, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @NonNull ObjectCounter onRamp, @NonNull ObjectCounter offRamp, boolean flushEnabled, boolean insertionIsBlocking) {
        super(model, name, TaskSchedulerType.CONCURRENT, flushEnabled, insertionIsBlocking);
        this.pool = Objects.requireNonNull(pool);
        this.uncaughtExceptionHandler = Objects.requireNonNull(uncaughtExceptionHandler);
        this.onRamp = Objects.requireNonNull(onRamp);
        this.offRamp = Objects.requireNonNull(offRamp);
    }

    @Override
    protected void put(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.onRamp();
        new ConcurrentTask(this.pool, this.offRamp, this.uncaughtExceptionHandler, handler, data).send();
    }

    @Override
    protected boolean offer(@NonNull Consumer<Object> handler, @NonNull Object data) {
        boolean accepted = this.onRamp.attemptOnRamp();
        if (accepted) {
            new ConcurrentTask(this.pool, this.offRamp, this.uncaughtExceptionHandler, handler, data).send();
        }
        return accepted;
    }

    @Override
    protected void inject(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.forceOnRamp();
        new ConcurrentTask(this.pool, this.offRamp, this.uncaughtExceptionHandler, handler, data).send();
    }

    @Override
    public long getUnprocessedTaskCount() {
        return this.onRamp.getCount();
    }

    @Override
    public void flush() {
        this.throwIfFlushDisabled();
        this.onRamp.waitUntilEmpty();
    }
}

