/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.schedulers.internal;

import com.swirlds.common.metrics.extensions.FractionalTimer;
import com.swirlds.common.wiring.counters.ObjectCounter;
import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.TaskScheduler;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;

public class DirectTaskScheduler<OUT>
extends TaskScheduler<OUT> {
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final ObjectCounter onRamp;
    private final ObjectCounter offRamp;
    private final FractionalTimer busyTimer;

    public DirectTaskScheduler(@NonNull StandardWiringModel model, @NonNull String name, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @NonNull ObjectCounter onRamp, @NonNull ObjectCounter offRamp, @NonNull FractionalTimer busyTimer, boolean stateless) {
        super(model, name, stateless ? TaskSchedulerType.DIRECT_STATELESS : TaskSchedulerType.DIRECT, false, true);
        this.uncaughtExceptionHandler = Objects.requireNonNull(uncaughtExceptionHandler);
        this.onRamp = Objects.requireNonNull(onRamp);
        this.offRamp = Objects.requireNonNull(offRamp);
        this.busyTimer = Objects.requireNonNull(busyTimer);
    }

    @Override
    public long getUnprocessedTaskCount() {
        return this.onRamp.getCount();
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException("Direct task schedulers do not support flushing");
    }

    @Override
    protected void put(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.onRamp();
        this.handleAndOffRamp(handler, data);
    }

    @Override
    protected boolean offer(@NonNull Consumer<Object> handler, @NonNull Object data) {
        boolean accepted = this.onRamp.attemptOnRamp();
        if (!accepted) {
            return false;
        }
        this.handleAndOffRamp(handler, data);
        return true;
    }

    @Override
    protected void inject(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.forceOnRamp();
        this.handleAndOffRamp(handler, data);
    }

    private void handleAndOffRamp(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.busyTimer.activate();
        try {
            handler.accept(data);
        }
        catch (Throwable t) {
            this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
        }
        this.busyTimer.deactivate();
        this.offRamp.offRamp();
    }
}

