/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.schedulers.internal;

import com.swirlds.base.state.Startable;
import com.swirlds.base.state.Stoppable;
import com.swirlds.base.time.Time;
import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.schedulers.internal.HeartbeatTask;
import com.swirlds.common.wiring.wires.output.OutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;

public class HeartbeatScheduler
implements Startable,
Stoppable {
    private final StandardWiringModel model;
    private final Time time;
    private final String name;
    private final Timer timer = new Timer();
    private final List<HeartbeatTask> tasks = new ArrayList<HeartbeatTask>();
    private boolean started;

    public HeartbeatScheduler(@NonNull StandardWiringModel model, @NonNull Time time, @NonNull String name) {
        this.model = Objects.requireNonNull(model);
        this.time = Objects.requireNonNull(time);
        this.name = Objects.requireNonNull(name);
        model.registerVertex(name, TaskSchedulerType.DIRECT, false);
    }

    @NonNull
    public OutputWire<Instant> buildHeartbeatWire(@NonNull Duration period) {
        if (this.started) {
            throw new IllegalStateException("Cannot create heartbeat wires after the heartbeat has started");
        }
        if (period.isNegative() || period.isZero()) {
            throw new IllegalArgumentException("Period must be positive");
        }
        if (period.toMillis() == 0L) {
            throw new IllegalArgumentException("Time is measured at millisecond precision, and so periods less than 1ms are not supported. Requested period: " + period);
        }
        HeartbeatTask task = new HeartbeatTask(this.model, this.name, this.time, period);
        this.tasks.add(task);
        return task.getOutputWire();
    }

    public OutputWire<Instant> buildHeartbeatWire(double frequency) {
        if (frequency <= 0.0) {
            throw new IllegalArgumentException("Frequency must be positive");
        }
        Duration period = Duration.ofMillis((long)(1000.0 / frequency));
        return this.buildHeartbeatWire(period);
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("Cannot start the heartbeat more than once");
        }
        this.started = true;
        for (HeartbeatTask task : this.tasks) {
            this.timer.scheduleAtFixedRate((TimerTask)task, 0L, task.getPeriod().toMillis());
        }
    }

    public void stop() {
        if (!this.started) {
            throw new IllegalStateException("Cannot stop the heartbeat before it has started");
        }
        this.timer.cancel();
    }
}

