/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.schedulers.internal;

import com.swirlds.common.metrics.extensions.FractionalTimer;
import com.swirlds.common.wiring.counters.ObjectCounter;
import com.swirlds.common.wiring.schedulers.internal.AbstractTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;

class SequentialTask
extends AbstractTask {
    private Consumer<Object> handler;
    private Object data;
    private SequentialTask nextTask;
    private final ObjectCounter offRamp;
    private final FractionalTimer busyTimer;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    SequentialTask(@NonNull ForkJoinPool pool, @NonNull ObjectCounter offRamp, @NonNull FractionalTimer busyTimer, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean firstTask) {
        super(pool, firstTask ? 1 : 2);
        this.offRamp = offRamp;
        this.busyTimer = busyTimer;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    void send(@NonNull SequentialTask nextTask, @NonNull Consumer<Object> handler, @Nullable Object data) {
        this.nextTask = nextTask;
        this.handler = handler;
        this.data = data;
        this.send();
    }

    @Override
    public boolean exec() {
        this.busyTimer.activate();
        try {
            this.handler.accept(this.data);
        }
        catch (Throwable t) {
            this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t);
        }
        finally {
            this.offRamp.offRamp();
            this.busyTimer.deactivate();
            this.nextTask.send();
        }
        return true;
    }
}

