/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.schedulers.internal;

import com.swirlds.common.metrics.extensions.FractionalTimer;
import com.swirlds.common.wiring.counters.ObjectCounter;
import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.TaskScheduler;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.schedulers.internal.SequentialTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class SequentialTaskScheduler<OUT>
extends TaskScheduler<OUT> {
    private final AtomicReference<SequentialTask> nextTaskPlaceholder;
    private final ObjectCounter onRamp;
    private final ObjectCounter offRamp;
    private final FractionalTimer busyTimer;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final ForkJoinPool pool;

    public SequentialTaskScheduler(@NonNull StandardWiringModel model, @NonNull String name, @NonNull ForkJoinPool pool, @NonNull Thread.UncaughtExceptionHandler uncaughtExceptionHandler, @NonNull ObjectCounter onRamp, @NonNull ObjectCounter offRamp, @NonNull FractionalTimer busyTimer, boolean flushEnabled, boolean insertionIsBlocking) {
        super(model, name, TaskSchedulerType.SEQUENTIAL, flushEnabled, insertionIsBlocking);
        this.pool = Objects.requireNonNull(pool);
        this.uncaughtExceptionHandler = Objects.requireNonNull(uncaughtExceptionHandler);
        this.onRamp = Objects.requireNonNull(onRamp);
        this.offRamp = Objects.requireNonNull(offRamp);
        this.busyTimer = Objects.requireNonNull(busyTimer);
        this.nextTaskPlaceholder = new AtomicReference<SequentialTask>(new SequentialTask(pool, offRamp, busyTimer, uncaughtExceptionHandler, true));
    }

    @Override
    protected void put(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.onRamp();
        this.scheduleTask(handler, data);
    }

    @Override
    protected boolean offer(@NonNull Consumer<Object> handler, @NonNull Object data) {
        boolean accepted = this.onRamp.attemptOnRamp();
        if (accepted) {
            this.scheduleTask(handler, data);
        }
        return accepted;
    }

    @Override
    protected void inject(@NonNull Consumer<Object> handler, @NonNull Object data) {
        this.onRamp.forceOnRamp();
        this.scheduleTask(handler, data);
    }

    private void scheduleTask(@NonNull Consumer<Object> handler, @NonNull Object data) {
        SequentialTask currentTask;
        SequentialTask nextTask = new SequentialTask(this.pool, this.offRamp, this.busyTimer, this.uncaughtExceptionHandler, false);
        while (!this.nextTaskPlaceholder.compareAndSet(currentTask = this.nextTaskPlaceholder.get(), nextTask)) {
        }
        currentTask.send(nextTask, handler, data);
    }

    @Override
    public long getUnprocessedTaskCount() {
        return this.onRamp.getCount();
    }

    @Override
    public void flush() {
        this.throwIfFlushDisabled();
        this.flushWithSemaphore().acquireUninterruptibly();
    }

    @NonNull
    private Semaphore flushWithSemaphore() {
        SequentialTask currentTask;
        this.onRamp.forceOnRamp();
        Semaphore semaphore = new Semaphore(0);
        SequentialTask nextTask = new SequentialTask(this.pool, this.offRamp, this.busyTimer, this.uncaughtExceptionHandler, false);
        while (!this.nextTaskPlaceholder.compareAndSet(currentTask = this.nextTaskPlaceholder.get(), nextTask)) {
        }
        currentTask.send(nextTask, x -> semaphore.release(), null);
        return semaphore;
    }
}

