/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.transformers.internal;

import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.wires.output.OutputWire;
import com.swirlds.common.wiring.wires.output.StandardOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class WireFilter<T>
implements Consumer<T> {
    private final Predicate<T> predicate;
    private final StandardOutputWire<T> outputWire;

    public WireFilter(@NonNull StandardWiringModel model, @NonNull String name, @NonNull Predicate<T> predicate) {
        this.predicate = Objects.requireNonNull(predicate);
        this.outputWire = new StandardOutputWire(model, name);
        model.registerVertex(name, TaskSchedulerType.DIRECT_STATELESS, true);
    }

    @Override
    public void accept(@NonNull T t) {
        if (this.predicate.test(t)) {
            this.outputWire.forward(t);
        }
    }

    @NonNull
    public OutputWire<T> getOutputWire() {
        return this.outputWire;
    }
}

