/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.transformers.internal;

import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.wires.output.OutputWire;
import com.swirlds.common.wiring.wires.output.StandardOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.function.Consumer;

public class WireListSplitter<T>
implements Consumer<List<T>> {
    private final StandardOutputWire<T> outputWire;

    public WireListSplitter(@NonNull StandardWiringModel model, @NonNull String name) {
        model.registerVertex(name, TaskSchedulerType.DIRECT_STATELESS, true);
        this.outputWire = new StandardOutputWire(model, name);
    }

    @Override
    public void accept(@NonNull List<T> list) {
        for (T t : list) {
            this.outputWire.forward(t);
        }
    }

    @NonNull
    public OutputWire<T> getOutputWire() {
        return this.outputWire;
    }
}

