/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.transformers.internal;

import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.schedulers.builders.TaskSchedulerType;
import com.swirlds.common.wiring.wires.output.OutputWire;
import com.swirlds.common.wiring.wires.output.StandardOutputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class WireTransformer<A, B>
implements Consumer<A> {
    private final Function<A, B> transformer;
    private final StandardOutputWire<B> outputWire;

    public WireTransformer(@NonNull StandardWiringModel model, @NonNull String name, @NonNull Function<A, B> transformer) {
        model.registerVertex(name, TaskSchedulerType.DIRECT_STATELESS, true);
        this.transformer = Objects.requireNonNull(transformer);
        this.outputWire = new StandardOutputWire(model, name);
    }

    @Override
    public void accept(@NonNull A a) {
        B b = this.transformer.apply(a);
        if (b != null) {
            this.outputWire.forward(b);
        }
    }

    @NonNull
    public OutputWire<B> getOutputWire() {
        return this.outputWire;
    }
}

