/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.wires.input;

import com.swirlds.common.wiring.schedulers.TaskScheduler;
import com.swirlds.common.wiring.wires.input.TaskSchedulerInput;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class InputWire<IN> {
    private final TaskSchedulerInput<?> taskSchedulerInput;
    private Consumer<Object> handler;
    private final String name;
    private final String taskSchedulerName;

    protected InputWire(@NonNull TaskScheduler<?> taskScheduler, @NonNull String name) {
        this.taskSchedulerInput = Objects.requireNonNull(taskScheduler);
        this.name = Objects.requireNonNull(name);
        this.taskSchedulerName = taskScheduler.getName();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getTaskSchedulerName() {
        return this.taskSchedulerName;
    }

    public void put(@NonNull IN data) {
        this.taskSchedulerInput.put(this.handler, data);
    }

    public boolean offer(@NonNull IN data) {
        return this.taskSchedulerInput.offer(this.handler, data);
    }

    public void inject(@NonNull IN data) {
        this.taskSchedulerInput.inject(this.handler, data);
    }

    protected void setHandler(@NonNull Consumer<Object> handler) {
        if (this.handler != null) {
            throw new IllegalStateException("Handler already bound");
        }
        this.handler = Objects.requireNonNull(handler);
    }
}

