/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.wiring.wires.output;

import com.swirlds.common.wiring.model.internal.StandardWiringModel;
import com.swirlds.common.wiring.transformers.AdvancedTransformation;
import com.swirlds.common.wiring.transformers.internal.AdvancedWireTransformer;
import com.swirlds.common.wiring.transformers.internal.WireFilter;
import com.swirlds.common.wiring.transformers.internal.WireListSplitter;
import com.swirlds.common.wiring.transformers.internal.WireTransformer;
import com.swirlds.common.wiring.wires.SolderType;
import com.swirlds.common.wiring.wires.input.InputWire;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class OutputWire<OUT> {
    private final StandardWiringModel model;
    private final String name;

    public OutputWire(@NonNull StandardWiringModel model, @NonNull String name) {
        this.model = Objects.requireNonNull(model);
        this.name = Objects.requireNonNull(name);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void solderTo(@NonNull InputWire<OUT> inputWire) {
        this.solderTo(inputWire, SolderType.PUT);
    }

    public void solderTo(@NonNull InputWire<OUT> inputWire, @NonNull SolderType solderType) {
        this.model.registerEdge(this.name, inputWire.getTaskSchedulerName(), inputWire.getName(), solderType);
        switch (solderType) {
            case PUT: {
                this.addForwardingDestination(inputWire::put);
                break;
            }
            case INJECT: {
                this.addForwardingDestination(inputWire::inject);
                break;
            }
            case OFFER: {
                this.addForwardingDestination(inputWire::offer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown solder type: " + solderType);
            }
        }
    }

    public void solderTo(@NonNull String handlerName, @NonNull Consumer<OUT> handler) {
        this.model.registerEdge(this.name, handlerName, "", SolderType.PUT);
        this.addForwardingDestination(Objects.requireNonNull(handler));
    }

    @NonNull
    public OutputWire<OUT> buildFilter(@NonNull String name, @NonNull Predicate<OUT> predicate) {
        WireFilter<OUT> filter = new WireFilter<OUT>(this.model, Objects.requireNonNull(name), Objects.requireNonNull(predicate));
        this.solderTo(name, filter);
        return filter.getOutputWire();
    }

    @NonNull
    public <ELEMENT> OutputWire<ELEMENT> buildSplitter() {
        String splitterName = this.name + "_splitter";
        WireListSplitter splitter = new WireListSplitter(this.model, splitterName);
        this.solderTo(splitterName, splitter);
        return splitter.getOutputWire();
    }

    @NonNull
    public <NEW_OUT> OutputWire<NEW_OUT> buildTransformer(@NonNull String name, @NonNull Function<OUT, NEW_OUT> transformer) {
        WireTransformer<OUT, NEW_OUT> wireTransformer = new WireTransformer<OUT, NEW_OUT>(this.model, Objects.requireNonNull(name), Objects.requireNonNull(transformer));
        this.solderTo(name, wireTransformer);
        return wireTransformer.getOutputWire();
    }

    @NonNull
    public <NEW_OUT> OutputWire<NEW_OUT> buildAdvancedTransformer(@NonNull String name, @NonNull Function<OUT, NEW_OUT> transform, @Nullable Consumer<OUT> cleanup) {
        AdvancedWireTransformer<OUT, NEW_OUT> wireTransformer = new AdvancedWireTransformer<OUT, NEW_OUT>(this.model, Objects.requireNonNull(name), transform, cleanup);
        this.solderTo(name, wireTransformer);
        return wireTransformer.getOutputWire();
    }

    @NonNull
    public <NEW_OUT> OutputWire<NEW_OUT> buildAdvancedTransformer(@NonNull AdvancedTransformation<OUT, NEW_OUT> transformer) {
        return this.buildAdvancedTransformer(transformer.getName(), transformer::transform, transformer::cleanup);
    }

    protected abstract void addForwardingDestination(@NonNull Consumer<OUT> var1);
}

