/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.constructable.internal;

import com.swirlds.common.constructable.ConstructableClass;
import com.swirlds.common.constructable.ConstructableIgnored;
import com.swirlds.common.constructable.NoArgsConstructor;
import com.swirlds.common.constructable.RuntimeConstructable;
import com.swirlds.common.constructable.URLClassLoaderWithLookup;
import com.swirlds.common.constructable.internal.ConstructableClasses;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;

public final class ConstructableScanner {
    private ConstructableScanner() {
    }

    public static Collection<ConstructableClasses<?>> getConstructableClasses(String packagePrefix, URLClassLoaderWithLookup additionalClassloader) {
        HashMap<Class, ConstructableClasses> map = new HashMap<Class, ConstructableClasses>();
        ClassGraph classGraph = new ClassGraph().enableClassInfo().whitelistPackages(new String[]{packagePrefix});
        if (additionalClassloader != null) {
            classGraph.addClassLoader((ClassLoader)additionalClassloader);
        }
        try (ScanResult scanResult = classGraph.scan();){
            for (ClassInfo classInfo : scanResult.getClassesImplementing(RuntimeConstructable.class.getCanonicalName())) {
                Class subType = classInfo.loadClass(RuntimeConstructable.class);
                if (ConstructableScanner.isSkippable(subType)) continue;
                Class<?> constructorType = ConstructableScanner.getConstructorType(subType);
                map.computeIfAbsent(constructorType, ConstructableClasses::new).addClass(subType);
            }
        }
        return map.values();
    }

    private static boolean isSkippable(Class<? extends RuntimeConstructable> subType) {
        return subType.isInterface() || Modifier.isAbstract(subType.getModifiers()) || subType.isAnnotationPresent(ConstructableIgnored.class);
    }

    private static Class<?> getConstructorType(Class<? extends RuntimeConstructable> subType) {
        return subType.isAnnotationPresent(ConstructableClass.class) ? subType.getAnnotation(ConstructableClass.class).constructorType() : NoArgsConstructor.class;
    }
}

