/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.constructable.internal;

import com.swirlds.common.constructable.ClassConstructorPair;
import com.swirlds.common.constructable.ConstructableRegistry;
import com.swirlds.common.constructable.ConstructableRegistryException;
import com.swirlds.common.constructable.ConstructorRegistry;
import com.swirlds.common.constructable.NoArgsConstructor;
import com.swirlds.common.constructable.RuntimeConstructable;
import com.swirlds.common.constructable.URLClassLoaderWithLookup;
import com.swirlds.common.constructable.internal.ConstructableClasses;
import com.swirlds.common.constructable.internal.ConstructableScanner;
import com.swirlds.common.constructable.internal.GenericConstructorRegistry;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class DefaultConstructableRegistry
implements ConstructableRegistry {
    private final Map<Class<?>, GenericConstructorRegistry<?>> allRegistries = new ConcurrentHashMap();

    @Override
    public <T> ConstructorRegistry<T> getRegistry(Class<T> constructorType) {
        return this.allRegistries.get(constructorType);
    }

    @Override
    public Supplier<RuntimeConstructable> getConstructor(long classId) {
        return this.getOrCreate(NoArgsConstructor.class).getConstructor(classId);
    }

    @Override
    public <T extends RuntimeConstructable> T createObject(long classId) {
        Supplier<RuntimeConstructable> c = this.getConstructor(classId);
        if (c == null) {
            return null;
        }
        return (T)c.get();
    }

    @Override
    public void registerConstructables(String packagePrefix, URLClassLoaderWithLookup additionalClassloader) throws ConstructableRegistryException {
        Collection<ConstructableClasses<?>> scanResults = ConstructableScanner.getConstructableClasses(packagePrefix, additionalClassloader);
        for (ConstructableClasses<?> constructableClasses : scanResults) {
            this.getOrCreate(constructableClasses.getConstructorType()).registerConstructables(constructableClasses, additionalClassloader);
        }
    }

    @Override
    public void registerConstructables(String packagePrefix) throws ConstructableRegistryException {
        this.registerConstructables(packagePrefix, null);
    }

    @Override
    public void registerConstructable(ClassConstructorPair pair) throws ConstructableRegistryException {
        this.getOrCreate(NoArgsConstructor.class).registerConstructable(pair.getConstructableClass(), ((Supplier<RuntimeConstructable>)pair.getConstructor())::get);
    }

    @Override
    public void reset() {
        this.allRegistries.clear();
    }

    private <T> GenericConstructorRegistry<T> getOrCreate(Class<T> constructor) {
        return this.allRegistries.computeIfAbsent(constructor, GenericConstructorRegistry::new);
    }
}

