/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public enum SignatureType {
    ED25519(0, "NONEwithED25519", "ED25519", "", 64, "x25519"),
    RSA(1, "SHA384withRSA", "RSA", SignatureType.getBCProviderName(), 384),
    ECDSA_SECP256K1(2, "NONEwithECDSA", "EC", SignatureType.getBCProviderName(), 64, "secp256k1");

    private final int id;
    private final String signingAlgorithm;
    private final String keyAlgorithm;
    private final String provider;
    private final int signatureLength;
    private final String ellipticalCurve;

    private static String getBCProviderName() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return "BC";
    }

    private SignatureType(int id, String signingAlgorithm, String keyAlgorithm, String provider, int signatureLength) {
        this(id, signingAlgorithm, keyAlgorithm, provider, signatureLength, null);
    }

    private SignatureType(int id, String signingAlgorithm, String keyAlgorithm, String provider, int signatureLength, String ellipticalCurve) {
        this.id = id;
        this.signingAlgorithm = signingAlgorithm;
        this.keyAlgorithm = keyAlgorithm;
        this.provider = provider;
        this.signatureLength = signatureLength;
        this.ellipticalCurve = ellipticalCurve;
    }

    public static SignatureType from(int id, SignatureType defaultValue) {
        return switch (id) {
            case 0 -> ED25519;
            case 1 -> RSA;
            case 2 -> ECDSA_SECP256K1;
            default -> defaultValue;
        };
    }

    public int id() {
        return this.id;
    }

    public String signingAlgorithm() {
        return this.signingAlgorithm;
    }

    public String keyAlgorithm() {
        return this.keyAlgorithm;
    }

    public String provider() {
        return this.provider;
    }

    public int signatureLength() {
        return this.signatureLength;
    }

    public String ellipticalCurve() {
        return this.ellipticalCurve;
    }
}

