/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.engine.OperationProvider;
import com.swirlds.common.threading.futures.StandardFuture;
import com.swirlds.logging.legacy.LogMarker;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AsyncOperationHandler<Element, Provider extends OperationProvider>
extends StandardFuture<Void>
implements Runnable {
    private static final Logger logger = LogManager.getLogger(AsyncOperationHandler.class);
    private final List<Element> workItems;
    private final Provider provider;

    public AsyncOperationHandler(List<Element> workItems, Provider provider) {
        this(workItems, false, provider);
    }

    public AsyncOperationHandler(List<Element> workItems, boolean shouldCopy, Provider provider) {
        this.workItems = shouldCopy ? new ArrayList<Element>(workItems) : workItems;
        this.provider = provider;
    }

    @Override
    public void run() {
        for (Element item : this.workItems) {
            try {
                this.handleWorkItem(this.provider, item);
            }
            catch (RuntimeException | NoSuchAlgorithmException ex) {
                logger.warn(LogMarker.TESTING_EXCEPTIONS.getMarker(), "Intercepted Uncaught Exception", (Throwable)ex);
            }
        }
        this.complete(null);
    }

    protected abstract void handleWorkItem(Provider var1, Element var2) throws NoSuchAlgorithmException;
}

