/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.CryptographyException;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.HashingOutputStream;
import com.swirlds.common.crypto.engine.CachingOperationProvider;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.logging.legacy.LogMarker;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SerializationDigestProvider
extends CachingOperationProvider<SelfSerializable, Void, Hash, HashingOutputStream, DigestType> {
    @Override
    protected HashingOutputStream handleAlgorithmRequired(DigestType algorithmType) throws NoSuchAlgorithmException {
        return new HashingOutputStream(MessageDigest.getInstance(algorithmType.algorithmName()));
    }

    @Override
    protected Hash handleItem(HashingOutputStream algorithm, DigestType algorithmType, SelfSerializable item, Void optionalData) {
        Hash hash;
        algorithm.resetDigest();
        SerializableDataOutputStream out = new SerializableDataOutputStream(algorithm);
        try {
            out.writeSerializable(item, true);
            out.flush();
            hash = new Hash(algorithm.getDigest(), algorithmType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new CryptographyException(ex, LogMarker.EXCEPTION);
            }
        }
        out.close();
        return hash;
    }
}

